/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.spring.runtime;

import io.contextmap.spring.runtime.ScanAtStartup;
import io.contextmap.spring.runtime.http.Parameters;
import io.contextmap.spring.runtime.model.ScanApplicationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ContextMapAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(ContextMapAutoConfiguration.class);
    @Value(value="${spring.application.name:}")
    private String appName;
    @Value(value="${spring.rabbitmq.virtual-host:}")
    private String defaultRabbitVirtualHost;
    @Value(value="${spring.cloud.azure.servicebus.namespace:}")
    private String defaultAzureServiceBusNamespace;
    @Value(value="${spring.cloud.azure.eventhubs.namespace:}")
    private String defaultAzureEventHubNamespace;
    @Value(value="${spring.jpa.properties.hibernate.default_schema:}")
    private String defaultStorageSchema;
    @Value(value="${contextmap.key:}")
    private String key;
    @Value(value="${contextmap.host:}")
    private String customHost;
    @Value(value="${contextmap.enabled:false}")
    private boolean scanningEnabled;
    @Value(value="${contextmap.dryRun:false}")
    private boolean dryRun;
    @Value(value="${contextmap.scan.multi-module-component-name:}")
    private String multiModuleComponentName;
    @Value(value="${contextmap.scan.component-name:}")
    private String componentName;

    @Bean
    public ScanAtStartup scanAtStartup(ApplicationContext applicationContext, ConfigurableBeanFactory beanFactory) {
        String name = this.componentName != null && !this.componentName.isEmpty() ? this.componentName : this.appName;
        ScanApplicationContext scanContext = new ScanApplicationContext(applicationContext, beanFactory, this.getParameters(), name);
        return new ScanAtStartup(scanContext);
    }

    private Parameters getParameters() {
        Parameters params = new Parameters();
        params.setMultiModuleComponentName(this.multiModuleComponentName);
        params.setDefaultStorageSchema(this.defaultStorageSchema);
        params.setDefaultRabbitVirtualHost(this.defaultRabbitVirtualHost);
        params.setDefaultAzureServiceBusNamespace(this.defaultAzureServiceBusNamespace);
        params.setDefaultAzureEventHubNamespace(this.defaultAzureEventHubNamespace);
        params.setDryRun(this.dryRun);
        params.setCustomHost(this.customHost);
        if (!this.scanningEnabled) {
            this.scanningEnabled = Boolean.getBoolean("contextmap.enabled");
        }
        params.setScanningEnabled(this.scanningEnabled);
        if (this.scanningEnabled) {
            if (this.key == null || this.key.isEmpty()) {
                try {
                    this.key = System.getProperty("contextmap.key");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.key == null || this.key.isEmpty()) {
                logger.error("Missing required \"contextmap.key\" configuration parameter");
            } else {
                params.setKey(this.key);
            }
        }
        return params;
    }
}

