/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.spring.runtime.scanner.events.rabbitmq;

import io.contextmap.spring.runtime.model.Event;
import io.contextmap.spring.runtime.model.Scan;
import io.contextmap.spring.runtime.model.ScanApplicationContext;
import io.contextmap.spring.runtime.scanner.events.EventFunctions;
import io.contextmap.spring.runtime.scanner.events.rabbitmq.AbstractRabbitMQScanner;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.integration.amqp.outbound.AbstractAmqpOutboundEndpoint;
import org.springframework.integration.amqp.outbound.AmqpOutboundEndpoint;
import org.springframework.integration.config.ConsumerEndpointFactoryBean;
import org.springframework.integration.dsl.IntegrationFlow;
import org.springframework.integration.dsl.StandardIntegrationFlow;

public class RabbitMQIntegrationFlowScanner
extends AbstractRabbitMQScanner {
    private static final Logger logger = LoggerFactory.getLogger(RabbitMQIntegrationFlowScanner.class);

    public RabbitMQIntegrationFlowScanner(ScanApplicationContext context) {
        super(context);
    }

    @Override
    public void scan(Scan data) {
        Map<String, ?> integrationFlowBeans = this.context.getBeansOfType("org.springframework.integration.dsl.IntegrationFlow");
        if (integrationFlowBeans.isEmpty()) {
            return;
        }
        logger.info("Scanning RabbitMQ events (IntegrationFlows)");
        data.getExecution().setScannedPublishedEvents(true);
        data.getExecution().setScannedSubscribedEvents(true);
        for (Object flow : integrationFlowBeans.values()) {
            Optional<Event> outboundFlow = this.reflectIntegrationFlows((IntegrationFlow)flow);
            outboundFlow.ifPresent(f -> data.addPublishedEvents(Collections.singleton(f)));
        }
    }

    private Optional<Event> reflectIntegrationFlows(IntegrationFlow flow) {
        try {
            if (flow instanceof StandardIntegrationFlow) {
                StandardIntegrationFlow integrationFlow = (StandardIntegrationFlow)flow;
                Map components = integrationFlow.getIntegrationComponents();
                for (Object comp : components.keySet()) {
                    Optional<Event> event;
                    if (!(comp instanceof ConsumerEndpointFactoryBean) || !(event = this.process(comp)).isPresent()) continue;
                    return event;
                }
            }
        }
        catch (Throwable t) {
            logger.warn("Issue while scanning RabbitMQ integration flows {}", (Object)t.getMessage());
        }
        return Optional.empty();
    }

    private Optional<Event> process(Object integrationComponent) {
        try {
            ConsumerEndpointFactoryBean consumerEndpointFactoryBean = (ConsumerEndpointFactoryBean)integrationComponent;
            Field field = ConsumerEndpointFactoryBean.class.getDeclaredField("handler");
            field.setAccessible(true);
            Object handler = field.get(consumerEndpointFactoryBean);
            if (handler instanceof AmqpOutboundEndpoint) {
                AmqpOutboundEndpoint amqpOutboundEndpoint = (AmqpOutboundEndpoint)handler;
                field = AmqpOutboundEndpoint.class.getDeclaredField("amqpTemplate");
                field.setAccessible(true);
                Object rabbitTemplate = field.get(amqpOutboundEndpoint);
                field = AbstractAmqpOutboundEndpoint.class.getDeclaredField("exchangeName");
                field.setAccessible(true);
                Object exchangeName = field.get(amqpOutboundEndpoint);
                if (rabbitTemplate != null && rabbitTemplate instanceof RabbitTemplate && exchangeName != null && ((String)exchangeName).length() > 0) {
                    String virtualHost = this.getVirtualHost((RabbitTemplate)rabbitTemplate);
                    String fullName = this.formatName(virtualHost, (String)exchangeName);
                    Event event = new Event(fullName, (String)exchangeName);
                    HashMap<String, Event> eventWrappedInMap = new HashMap<String, Event>();
                    eventWrappedInMap.put(event.getName(), event);
                    eventWrappedInMap.put((String)exchangeName, event);
                    Map<Class<?>, Set<EventFunctions.PayloadExchangeProperties>> eventClassToPublishers = EventFunctions.getPayloadProperties(this.context, this::resolveExchangeNameFromPublishedByName);
                    EventFunctions.addPayloadsToEvents(eventClassToPublishers, eventWrappedInMap);
                    this.addPropertiesToEventFromRabbitTemplate(event, (RabbitTemplate)rabbitTemplate, (String)exchangeName);
                    return Optional.of(event);
                }
            }
        }
        catch (Exception e) {
            logger.debug("Issue while processing RabbitMQ integration flows", (Throwable)e);
        }
        return Optional.empty();
    }
}

