/*
 * Decompiled with CFR 0.152.
 */
package esa.httpserver;

import esa.httpserver.MultipartOptions;
import io.netty.handler.codec.http.HttpConstants;
import java.nio.charset.Charset;

public final class MultipartOptionsConfigure {
    private long memoryThreshold = 0x200000L;
    private long maxSize = -1L;
    private Charset charset = HttpConstants.DEFAULT_CHARSET;
    private String tempDir;
    private boolean useDisk;

    private MultipartOptionsConfigure() {
    }

    public static MultipartOptionsConfigure newOpts() {
        return new MultipartOptionsConfigure();
    }

    public MultipartOptionsConfigure memoryThreshold(long memoryThreshold) {
        this.memoryThreshold = memoryThreshold;
        return this;
    }

    public MultipartOptionsConfigure maxSize(long maxSize) {
        this.maxSize = maxSize;
        return this;
    }

    public MultipartOptionsConfigure charset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public MultipartOptionsConfigure tempDir(String tempDir) {
        this.tempDir = tempDir;
        return this;
    }

    public MultipartOptionsConfigure useDisk(boolean useDisk) {
        this.useDisk = useDisk;
        return this;
    }

    public MultipartOptions configured() {
        MultipartOptions multipartOptions = new MultipartOptions();
        multipartOptions.setUseDisk(this.useDisk);
        multipartOptions.setMemoryThreshold(this.memoryThreshold);
        multipartOptions.setMaxSize(this.maxSize);
        multipartOptions.setCharset(this.charset);
        multipartOptions.setTempDir(this.tempDir);
        return multipartOptions;
    }
}

