/*
 * Decompiled with CFR 0.152.
 */
package esa.httpserver.impl;

import esa.commons.ExceptionUtils;
import esa.commons.http.HttpMethod;
import esa.httpserver.core.Response;
import esa.httpserver.impl.BaseResponse;
import esa.httpserver.impl.Http2ChunkedInput;
import esa.httpserver.impl.Http2HeadersImpl;
import esa.httpserver.impl.Http2RequestHandleImpl;
import esa.httpserver.impl.Utils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpStatusClass;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.stream.ChunkedFile;
import io.netty.handler.stream.ChunkedInput;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.Future;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

final class Http2ResponseImpl
extends BaseResponse<Http2RequestHandleImpl>
implements Response {
    private static final AttributeKey<Object> CLOSE_LOCK = AttributeKey.valueOf((String)"$closeOnShutdown");
    private static final ChannelFutureListener CLOSE = future -> {
        Channel ch = future.channel();
        if (ch.isActive() && ch.attr(CLOSE_LOCK).compareAndSet(null, (Object)Boolean.TRUE)) {
            future.channel().close();
        }
    };
    private final Http2HeadersImpl headers = new Http2HeadersImpl();
    private final Http2ConnectionEncoder encoder;
    private final int streamDependency;
    private final short weight;
    private final boolean exclusive;
    private Http2HeadersImpl trailers;

    Http2ResponseImpl(Http2RequestHandleImpl req, Http2ConnectionEncoder encoder, int streamDependency, short weight, boolean exclusive) {
        super(req);
        this.encoder = encoder;
        this.streamDependency = streamDependency;
        this.weight = weight;
        this.exclusive = exclusive;
    }

    public Http2HeadersImpl headers() {
        return this.headers;
    }

    public Http2HeadersImpl trailers() {
        if (this.trailers == null) {
            this.trailers = new Http2HeadersImpl();
        }
        return this.trailers;
    }

    @Override
    public boolean isWritable() {
        if (this.inEventLoop()) {
            return this.encoder.flowController().isWritable(((Http2RequestHandleImpl)this.request).stream);
        }
        return this.ctx().channel().isWritable();
    }

    @Override
    Future<Void> doWrite(byte[] data, int offset, int length, boolean writeHead) {
        if (writeHead) {
            this.buildHeaders(-1L);
            if (this.inEventLoop()) {
                ChannelPromise promise = this.ctx().newPromise();
                this.doWriteHeaders(this.headers.unwrap(), false, promise);
                if (length > 0) {
                    promise = this.ctx().newPromise();
                    this.doWriteData(Utils.toByteBuf(this.alloc(), data, offset, length), false, promise);
                }
                this.flush();
                return promise;
            }
            if (length == 0) {
                ChannelPromise promise = this.ctx().newPromise();
                this.safeRunInChannel(() -> {
                    this.doWriteHeaders(this.headers.unwrap(), false, promise);
                    this.flush();
                }, promise, null);
                return promise;
            }
            ChannelPromise promise = this.ctx().newPromise();
            this.safeRunInChannel(() -> {
                this.doWriteHeaders(this.headers.unwrap(), false, this.ctx().newPromise());
                this.doWriteData(Utils.toByteBuf(this.alloc(), data, offset, length), false, promise);
                this.flush();
            }, promise, data);
            return promise;
        }
        if (length == 0) {
            return this.ctx().newSucceededFuture();
        }
        if (this.inEventLoop()) {
            ChannelFuture f = this.doWriteData(Utils.toByteBuf(this.alloc(), data, offset, length), false, this.ctx().newPromise());
            this.flush();
            return f;
        }
        ChannelPromise promise = this.ctx().newPromise();
        this.safeRunInChannel(() -> {
            this.doWriteData(Utils.toByteBuf(this.alloc(), data, offset, length), false, promise);
            this.flush();
        }, promise, data);
        return promise;
    }

    @Override
    Future<Void> doWrite(ByteBuf data, boolean writeHead) {
        if (writeHead) {
            this.buildHeaders(-1L);
            if (this.inEventLoop()) {
                ChannelPromise promise = this.ctx().newPromise();
                this.doWriteHeaders(this.headers.unwrap(), false, promise);
                if (data.isReadable()) {
                    promise = this.ctx().newPromise();
                    this.doWriteData(data, false, promise);
                } else {
                    data.release();
                }
                this.flush();
                return promise;
            }
            if (data.isReadable()) {
                ChannelPromise promise = this.ctx().newPromise();
                this.safeRunInChannel(() -> {
                    this.doWriteHeaders(this.headers.unwrap(), false, this.ctx().newPromise());
                    this.doWriteData(data, false, promise);
                    this.flush();
                }, promise, data);
                return promise;
            }
            ChannelPromise promise = this.ctx().newPromise();
            data.release();
            this.safeRunInChannel(() -> {
                this.doWriteHeaders(this.headers.unwrap(), false, promise);
                this.flush();
            }, promise, null);
            return promise;
        }
        if (data.isReadable()) {
            if (this.inEventLoop()) {
                ChannelFuture f = this.doWriteData(data, false, this.ctx().newPromise());
                this.flush();
                return f;
            }
            ChannelPromise promise = this.ctx().newPromise();
            this.safeRunInChannel(() -> {
                this.doWriteData(data, false, promise);
                this.flush();
            }, promise, data);
            return promise;
        }
        data.release();
        return this.ctx().newSucceededFuture();
    }

    @Override
    void doEnd(ByteBuf data, boolean writeHead, boolean forceClose) {
        boolean isTrailerAbsent = this.isTrailerAbsent();
        if (writeHead) {
            int bytesToWrite = data.readableBytes();
            this.buildHeaders(bytesToWrite);
            if (this.inEventLoop()) {
                if (bytesToWrite == 0 && isTrailerAbsent) {
                    this.doWriteHeaders(this.headers.unwrap(), true, this.endPromise);
                    data.release();
                } else if (isTrailerAbsent) {
                    this.doWriteHeaders(this.headers.unwrap(), false, this.ctx().newPromise());
                    this.doWriteData(data, true, this.endPromise);
                } else {
                    this.doWriteHeaders(this.headers.unwrap(), false, this.ctx().newPromise());
                    this.doWriteData(data, false, this.ctx().newPromise());
                    this.doWriteHeaders(this.trailers().unwrap(), true, this.endPromise);
                }
                this.flush();
            } else if (bytesToWrite == 0 && isTrailerAbsent) {
                data.release();
                this.safeRunInChannel(() -> {
                    this.doWriteHeaders(this.headers.unwrap(), true, this.endPromise);
                    this.flush();
                }, this.endPromise, null);
            } else if (isTrailerAbsent) {
                this.safeRunInChannel(() -> {
                    this.doWriteHeaders(this.headers.unwrap(), false, this.ctx().newPromise());
                    this.doWriteData(data, true, this.endPromise);
                    this.flush();
                }, this.endPromise, data);
            } else {
                this.safeRunInChannel(() -> {
                    this.doWriteHeaders(this.headers.unwrap(), false, this.ctx().newPromise());
                    this.doWriteData(data, false, this.ctx().newPromise());
                    this.doWriteHeaders(this.trailers().unwrap(), true, this.endPromise);
                    this.flush();
                }, this.endPromise, data);
            }
        } else if (this.inEventLoop()) {
            if (isTrailerAbsent) {
                this.doWriteData(data, true, this.endPromise);
            } else {
                this.doWriteData(data, false, this.ctx().newPromise());
                this.doWriteHeaders(this.trailers().unwrap(), true, this.endPromise);
            }
            this.flush();
        } else if (isTrailerAbsent) {
            this.safeRunInChannel(() -> {
                this.doWriteData(data, true, this.endPromise);
                this.flush();
            }, this.endPromise, data);
        } else {
            this.safeRunInChannel(() -> {
                this.doWriteData(data, false, this.ctx().newPromise());
                this.doWriteHeaders(this.trailers().unwrap(), true, this.endPromise);
                this.flush();
            }, this.endPromise, data);
        }
    }

    @Override
    void doEnd(byte[] data, int offset, int length, boolean writeHead) {
        boolean isTrailerAbsent = this.isTrailerAbsent();
        if (writeHead) {
            this.buildHeaders(length);
            if (this.inEventLoop()) {
                if (length == 0 && isTrailerAbsent) {
                    this.doWriteHeaders(this.headers.unwrap(), true, this.endPromise);
                } else if (isTrailerAbsent) {
                    this.doWriteHeaders(this.headers.unwrap(), false, this.ctx().newPromise());
                    this.doWriteData(Utils.toByteBuf(this.alloc(), data, offset, length), true, this.endPromise);
                } else {
                    this.doWriteHeaders(this.headers.unwrap(), false, this.ctx().newPromise());
                    this.doWriteData(Utils.toByteBuf(this.alloc(), data, offset, length), false, this.ctx().newPromise());
                    this.doWriteHeaders(this.trailers().unwrap(), true, this.endPromise);
                }
                this.flush();
            } else if (length == 0 && isTrailerAbsent) {
                this.safeRunInChannel(() -> {
                    this.doWriteHeaders(this.headers.unwrap(), true, this.endPromise);
                    this.flush();
                }, this.endPromise, null);
            } else if (isTrailerAbsent) {
                this.safeRunInChannel(() -> {
                    this.doWriteHeaders(this.headers.unwrap(), false, this.ctx().newPromise());
                    this.doWriteData(Utils.toByteBuf(this.alloc(), data, offset, length), true, this.endPromise);
                    this.flush();
                }, this.endPromise, data);
            } else {
                this.safeRunInChannel(() -> {
                    this.doWriteHeaders(this.headers.unwrap(), false, this.ctx().newPromise());
                    this.doWriteData(Utils.toByteBuf(this.alloc(), data, offset, length), false, this.ctx().newPromise());
                    this.doWriteHeaders(this.trailers().unwrap(), true, this.endPromise);
                    this.flush();
                }, this.endPromise, data);
            }
        } else if (this.inEventLoop()) {
            if (isTrailerAbsent) {
                this.doWriteData(Utils.toByteBuf(this.alloc(), data, offset, length), true, this.endPromise);
            } else {
                this.doWriteData(Utils.toByteBuf(this.alloc(), data, offset, length), false, this.ctx().newPromise());
                this.doWriteHeaders(this.trailers().unwrap(), true, this.endPromise);
            }
            this.flush();
        } else if (isTrailerAbsent) {
            this.safeRunInChannel(() -> {
                this.doWriteData(Utils.toByteBuf(this.alloc(), data, offset, length), true, this.endPromise);
                this.flush();
            }, this.endPromise, data);
        } else {
            this.safeRunInChannel(() -> {
                this.doWriteData(Utils.toByteBuf(this.alloc(), data, offset, length), false, this.ctx().newPromise());
                this.doWriteHeaders(this.trailers().unwrap(), true, this.endPromise);
                this.flush();
            }, this.endPromise, data);
        }
    }

    @Override
    void doSendFile(File file, long position, long len) {
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(file, "r");
            this.buildHeaders(len);
            Http2ChunkedInput chunkedInput = new Http2ChunkedInput((ChunkedInput<ByteBuf>)new ChunkedFile(raf, position, len, 8192), this.isTrailerAbsent() ? null : this.trailers.unwrap(), ((Http2RequestHandleImpl)this.request).stream.id(), this.streamDependency, this.weight, this.exclusive);
            if (this.inEventLoop()) {
                this.doWriteHeaders(this.headers.unwrap(), false, this.ctx().newPromise());
                this.ctx().channel().writeAndFlush((Object)chunkedInput, this.endPromise);
            } else {
                this.safeRunInChannel(() -> {
                    this.doWriteHeaders(this.headers.unwrap(), false, this.ctx().newPromise());
                    this.ctx().channel().writeAndFlush((Object)chunkedInput, this.endPromise);
                }, this.endPromise, chunkedInput);
            }
        }
        catch (Throwable e) {
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.inEventLoop()) {
                ((Http2RequestHandleImpl)this.request).stream.close();
            } else {
                this.ctx().channel().eventLoop().execute(() -> ((Http2Stream)((Http2RequestHandleImpl)this.request).stream).close());
            }
            ExceptionUtils.throwException((Throwable)e);
        }
    }

    @Override
    ChannelFutureListener closure() {
        return CLOSE;
    }

    private ChannelFuture doWriteData(ByteBuf data, boolean endStream, ChannelPromise promise) {
        return this.encoder.writeData(this.ctx(), ((Http2RequestHandleImpl)this.request).stream.id(), data, 0, endStream, promise);
    }

    private void doWriteHeaders(Http2Headers headers, boolean endStream, ChannelPromise promise) {
        this.encoder.writeHeaders(this.ctx(), ((Http2RequestHandleImpl)this.request).stream.id(), headers, this.streamDependency, this.weight, this.exclusive, 0, endStream, promise);
    }

    private void buildHeaders(long contentLength) {
        this.headers.unwrap().status((CharSequence)Integer.toString(this.status));
        if (contentLength > 0L) {
            this.headers.setLong((CharSequence)HttpHeaderNames.CONTENT_LENGTH, contentLength);
        } else if (((Http2RequestHandleImpl)this.request).method().equals((Object)HttpMethod.HEAD) || this.status == HttpResponseStatus.NOT_MODIFIED.code() || HttpStatusClass.INFORMATIONAL.equals((Object)HttpStatusClass.valueOf((int)this.status))) {
            this.headers.remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
        } else if (this.status == HttpResponseStatus.RESET_CONTENT.code()) {
            this.headers.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, "0");
        }
    }

    private boolean isTrailerAbsent() {
        return this.trailers == null || this.trailers.isEmpty();
    }

    private void flush() {
        this.ctx().channel().flush();
    }

    private boolean inEventLoop() {
        return this.ctx().channel().eventLoop().inEventLoop();
    }

    private void safeRunInChannel(Runnable r, ChannelPromise promise, Object data) {
        Utils.safeRunInChannel(this.ctx(), r, promise, data);
    }
}

