/*
 * Decompiled with CFR 0.152.
 */
package esa.httpserver;

import esa.commons.Checks;
import esa.commons.annotation.Beta;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.handler.logging.LogLevel;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class NetOptions
implements Serializable {
    private static final long serialVersionUID = -1189110101771190532L;
    private boolean preferNativeTransport = true;
    private boolean soKeepalive = true;
    private boolean tcpNoDelay = true;
    private boolean reuseAddress = true;
    private boolean reusePort = true;
    private boolean tcpFastOpen;
    private boolean tcpCork;
    private boolean tcpQuickAck;
    private int soRcvbuf;
    private int soSendbuf;
    private int soBacklog = 128;
    private int soLinger = -1;
    private int writeBufferHighWaterMark;
    private int writeBufferLowWaterMark;
    private int idleTimeoutSeconds = 60;
    private final Map<ChannelOption<?>, Object> options = new LinkedHashMap();
    private final Map<ChannelOption<?>, Object> childOptions = new LinkedHashMap();
    private LogLevel logging;
    @Beta
    private List<ChannelHandler> channelHandlers = new LinkedList<ChannelHandler>();

    public NetOptions() {
    }

    public NetOptions(NetOptions other) {
        Checks.checkNotNull((Object)other, (String)"other");
        this.preferNativeTransport = other.preferNativeTransport;
        this.soKeepalive = other.soKeepalive;
        this.tcpNoDelay = other.tcpNoDelay;
        this.reuseAddress = other.reuseAddress;
        this.reusePort = other.reusePort;
        this.tcpFastOpen = other.tcpFastOpen;
        this.tcpCork = other.tcpCork;
        this.tcpQuickAck = other.tcpQuickAck;
        this.soRcvbuf = other.soRcvbuf;
        this.soSendbuf = other.soSendbuf;
        this.soBacklog = other.soBacklog;
        this.soLinger = other.soLinger;
        this.writeBufferHighWaterMark = other.writeBufferHighWaterMark;
        this.writeBufferLowWaterMark = other.writeBufferLowWaterMark;
        this.idleTimeoutSeconds = other.idleTimeoutSeconds;
        this.options.putAll(other.options);
        this.childOptions.putAll(other.childOptions);
        this.soSendbuf = other.soSendbuf;
        this.logging = other.logging;
        this.channelHandlers.addAll(other.channelHandlers);
    }

    public boolean isPreferNativeTransport() {
        return this.preferNativeTransport;
    }

    public void setPreferNativeTransport(boolean preferNativeTransport) {
        this.preferNativeTransport = preferNativeTransport;
    }

    public boolean isReuseAddress() {
        return this.reuseAddress;
    }

    public void setReuseAddress(boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
    }

    public boolean isReusePort() {
        return this.reusePort;
    }

    public void setReusePort(boolean reusePort) {
        this.reusePort = reusePort;
    }

    public boolean isSoKeepalive() {
        return this.soKeepalive;
    }

    public void setSoKeepalive(boolean soKeepalive) {
        this.soKeepalive = soKeepalive;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public boolean isTcpFastOpen() {
        return this.tcpFastOpen;
    }

    public void setTcpFastOpen(boolean tcpFastOpen) {
        this.tcpFastOpen = tcpFastOpen;
    }

    public boolean isTcpCork() {
        return this.tcpCork;
    }

    public void setTcpCork(boolean tcpCork) {
        this.tcpCork = tcpCork;
    }

    public boolean isTcpQuickAck() {
        return this.tcpQuickAck;
    }

    public void setTcpQuickAck(boolean tcpQuickAck) {
        this.tcpQuickAck = tcpQuickAck;
    }

    public int getSoRcvbuf() {
        return this.soRcvbuf;
    }

    public void setSoRcvbuf(int soRcvbuf) {
        this.soRcvbuf = soRcvbuf;
    }

    public int getSoSendbuf() {
        return this.soSendbuf;
    }

    public void setSoSendbuf(int soSendbuf) {
        this.soSendbuf = soSendbuf;
    }

    public int getSoBacklog() {
        return this.soBacklog;
    }

    public void setSoBacklog(int soBacklog) {
        this.soBacklog = soBacklog;
    }

    public int getSoLinger() {
        return this.soLinger;
    }

    public void setSoLinger(int soLinger) {
        this.soLinger = soLinger;
    }

    public int getWriteBufferHighWaterMark() {
        return this.writeBufferHighWaterMark;
    }

    public void setWriteBufferHighWaterMark(int writeBufferHighWaterMark) {
        this.writeBufferHighWaterMark = writeBufferHighWaterMark;
    }

    public int getWriteBufferLowWaterMark() {
        return this.writeBufferLowWaterMark;
    }

    public void setWriteBufferLowWaterMark(int writeBufferLowWaterMark) {
        this.writeBufferLowWaterMark = writeBufferLowWaterMark;
    }

    public int getIdleTimeoutSeconds() {
        return this.idleTimeoutSeconds;
    }

    public void setIdleTimeoutSeconds(int idleTimeoutSeconds) {
        this.idleTimeoutSeconds = idleTimeoutSeconds;
    }

    public Map<ChannelOption<?>, Object> getOptions() {
        return this.options;
    }

    public void setOptions(Map<ChannelOption<?>, Object> options) {
        if (options != null && !options.isEmpty()) {
            this.options.clear();
            this.options.putAll(options);
        }
    }

    public Map<ChannelOption<?>, Object> getChildOptions() {
        return this.childOptions;
    }

    public void setChildOptions(Map<ChannelOption<?>, Object> options) {
        if (options != null && !options.isEmpty()) {
            this.childOptions.clear();
            this.childOptions.putAll(options);
        }
    }

    public LogLevel getLogging() {
        return this.logging;
    }

    public void setLogging(LogLevel logging) {
        this.logging = logging;
    }

    public List<ChannelHandler> getChannelHandlers() {
        return this.channelHandlers;
    }

    public void setChannelHandlers(List<ChannelHandler> channelHandlers) {
        this.channelHandlers = channelHandlers;
    }
}

