/*
 * Decompiled with CFR 0.152.
 */
package esa.httpserver.impl;

import esa.commons.http.HttpHeaders;
import esa.commons.netty.http.EmptyHttpHeaders;
import esa.httpserver.core.Aggregation;
import esa.httpserver.impl.Utils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.ReferenceCounted;

final class AggregationHandle
implements Aggregation {
    static final Empty EMPTY = new Empty();
    private static final int MAX_COMPOSITE_BUFFER_COMPONENTS = 1024;
    private final ChannelHandlerContext ctx;
    private CompositeByteBuf content;
    private HttpHeaders trailers;

    AggregationHandle(ChannelHandlerContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public ByteBuf body() {
        if (this.content == null) {
            return EMPTY.body();
        }
        return this.content;
    }

    @Override
    public HttpHeaders trailers() {
        if (this.trailers == null) {
            return EMPTY.trailers();
        }
        return this.trailers;
    }

    void setTrailers(HttpHeaders trailers) {
        this.trailers = trailers;
    }

    void appendPartialContent(ByteBuf partialContent) {
        if (partialContent.isReadable()) {
            if (this.content == null) {
                this.content = this.ctx.alloc().compositeBuffer(1024);
            }
            this.content.addComponent(true, partialContent);
        }
    }

    void release() {
        if (this.content != null) {
            Utils.tryRelease((ReferenceCounted)this.content);
        }
    }

    private static class Empty
    implements Aggregation {
        private Empty() {
        }

        @Override
        public ByteBuf body() {
            return Unpooled.EMPTY_BUFFER;
        }

        @Override
        public HttpHeaders trailers() {
            return EmptyHttpHeaders.INSTANCE;
        }
    }
}

