/*
 * Decompiled with CFR 0.152.
 */
package esa.httpserver.impl;

import esa.httpserver.impl.HAProxyMessageHandler;
import esa.httpserver.impl.Utils;
import esa.httpserver.utils.Loggers;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.ProtocolDetectionResult;
import io.netty.handler.codec.ProtocolDetectionState;
import io.netty.handler.codec.haproxy.HAProxyMessageDecoder;
import java.util.List;

final class HAProxyDetector
extends ByteToMessageDecoder {
    HAProxyDetector() {
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        ProtocolDetectionResult ha = HAProxyMessageDecoder.detectProtocol((ByteBuf)in);
        if (ha.state() == ProtocolDetectionState.NEEDS_MORE_DATA) {
            return;
        }
        if (ha.state() == ProtocolDetectionState.DETECTED) {
            if (Loggers.logger().isDebugEnabled()) {
                Loggers.logger().debug("Detected HAProxy protocol version of {} in connection {}", ha.detectedProtocol(), (Object)ctx.channel());
            }
            ctx.pipeline().addAfter(ctx.name(), "HAProxyMessageHandler", (ChannelHandler)new HAProxyMessageHandler());
            ctx.pipeline().replace((ChannelHandler)this, "HAProxyDecoder", (ChannelHandler)new HAProxyMessageDecoder());
        } else {
            ctx.pipeline().remove((ChannelHandler)this);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        Utils.handleException(ctx, cause);
    }
}

