/*
 * Decompiled with CFR 0.152.
 */
package esa.httpserver.impl;

import esa.commons.ExceptionUtils;
import esa.commons.http.HttpMethod;
import esa.commons.netty.http.Http1HeadersImpl;
import esa.httpserver.core.Response;
import esa.httpserver.impl.AggregatedLastHttpContent;
import esa.httpserver.impl.BaseResponse;
import esa.httpserver.impl.Http1RequestHandleImpl;
import esa.httpserver.impl.Utils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultFileRegion;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.HttpChunkedInput;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedFile;
import io.netty.handler.stream.ChunkedInput;
import io.netty.util.concurrent.Future;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

final class Http1ResponseImpl
extends BaseResponse<Http1RequestHandleImpl>
implements Response {
    private final Http1HeadersImpl headers = new Http1HeadersImpl();
    private final boolean isKeepAlive;
    private Http1HeadersImpl trailers;

    Http1ResponseImpl(Http1RequestHandleImpl req, boolean isKeepAlive) {
        super(req);
        this.isKeepAlive = isKeepAlive;
    }

    public Http1HeadersImpl headers() {
        return this.headers;
    }

    @Override
    public boolean isKeepAlive() {
        return this.isKeepAlive && ((Http1RequestHandleImpl)this.request).runtime.isRunning();
    }

    public Http1HeadersImpl trailers() {
        if (this.trailers == null) {
            this.trailers = new Http1HeadersImpl();
        }
        return this.trailers;
    }

    @Override
    Future<Void> doWrite(byte[] data, int offset, int length, boolean writeHead) {
        if (writeHead) {
            if (this.inEventLoop()) {
                ChannelPromise promise = this.ctx().newPromise();
                this.ctx().write((Object)this.buildResponseHead(-1L), promise);
                if (length == 0) {
                    this.ctx().flush();
                } else {
                    promise = this.ctx().newPromise();
                    this.ctx().writeAndFlush((Object)new DefaultHttpContent(Utils.toByteBuf(this.alloc(), data, offset, length)), promise);
                }
                return promise;
            }
            if (length == 0) {
                return this.ctx().write((Object)this.buildResponseHead(-1L));
            }
            ChannelPromise promise = this.ctx().newPromise();
            DefaultHttpResponse head = this.buildResponseHead(-1L);
            this.safeRunInChannel(() -> {
                this.ctx().write((Object)head, this.ctx().newPromise());
                this.ctx().writeAndFlush((Object)new DefaultHttpContent(Utils.toByteBuf(this.alloc(), data, offset, length)), promise);
            }, promise, null);
            return promise;
        }
        if (length == 0) {
            return this.ctx().newSucceededFuture();
        }
        if (this.inEventLoop()) {
            return this.ctx().writeAndFlush((Object)new DefaultHttpContent(Utils.toByteBuf(this.alloc(), data, offset, length)));
        }
        ChannelPromise promise = this.ctx().newPromise();
        this.safeRunInChannel(() -> this.ctx().writeAndFlush((Object)new DefaultHttpContent(Utils.toByteBuf(this.alloc(), data, offset, length)), promise), promise, null);
        return promise;
    }

    @Override
    Future<Void> doWrite(ByteBuf data, boolean writeHead) {
        if (writeHead) {
            if (this.inEventLoop()) {
                ChannelPromise promise = this.ctx().newPromise();
                this.ctx().write((Object)this.buildResponseHead(-1L), promise);
                if (data.isReadable()) {
                    promise = this.ctx().newPromise();
                    this.ctx().writeAndFlush((Object)new DefaultHttpContent(data), promise);
                } else {
                    data.release();
                    this.ctx().flush();
                }
                return promise;
            }
            if (data.isReadable()) {
                ChannelPromise promise = this.ctx().newPromise();
                DefaultHttpResponse head = this.buildResponseHead(-1L);
                this.safeRunInChannel(() -> {
                    this.ctx().write((Object)head, this.ctx().newPromise());
                    this.ctx().writeAndFlush((Object)new DefaultHttpContent(data), promise);
                }, promise, data);
                return promise;
            }
            data.release();
            return this.ctx().write((Object)this.buildResponseHead(-1L));
        }
        if (data.isReadable()) {
            return this.ctx().writeAndFlush((Object)new DefaultHttpContent(data));
        }
        data.release();
        return this.ctx().newSucceededFuture();
    }

    @Override
    void doEnd(ByteBuf data, boolean writeHead, boolean forceClose) {
        if (writeHead) {
            this.standardHeaders(data.readableBytes(), forceClose);
            this.ctx().writeAndFlush((Object)this.buildFullResponse(data), this.endPromise);
        } else {
            LastHttpContent last = this.getLastHttpContent(data);
            if (last == LastHttpContent.EMPTY_LAST_CONTENT) {
                data.release();
            }
            this.ctx().writeAndFlush((Object)last, this.endPromise);
        }
    }

    @Override
    void doEnd(byte[] data, int offset, int length, boolean writeHead) {
        if (writeHead) {
            this.standardHeaders(length, false);
            if (this.inEventLoop()) {
                this.ctx().writeAndFlush((Object)this.buildFullResponse(Utils.toByteBuf(this.alloc(), data, offset, length)), this.endPromise);
            } else {
                this.safeRunInChannel(() -> this.ctx().writeAndFlush((Object)this.buildFullResponse(Utils.toByteBuf(this.alloc(), data, offset, length)), this.endPromise), this.endPromise, null);
            }
        } else if (this.inEventLoop()) {
            this.ctx().writeAndFlush((Object)this.getLastHttpContent(Utils.toByteBuf(this.alloc(), data, offset, length)), this.endPromise);
        } else {
            this.safeRunInChannel(() -> this.ctx().writeAndFlush((Object)this.getLastHttpContent(Utils.toByteBuf(this.alloc(), data, offset, length)), this.endPromise), this.endPromise, null);
        }
    }

    private DefaultFullHttpResponse buildFullResponse(ByteBuf data) {
        return new DefaultFullHttpResponse(((Http1RequestHandleImpl)this.request).req.protocolVersion(), HttpResponseStatus.valueOf((int)this.status), data, (HttpHeaders)this.headers, (HttpHeaders)(this.trailers == null ? EmptyHttpHeaders.INSTANCE : this.trailers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void doSendFile(File file, long position, long len) {
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(file, "r");
            this.ctx().write((Object)this.buildResponseHead(len));
            if (this.supportFileRegion()) {
                this.ctx().write((Object)new DefaultFileRegion(raf.getChannel(), position, len));
                this.ctx().writeAndFlush((Object)this.getLastHttpContent(), this.endPromise);
            } else {
                this.ctx().writeAndFlush((Object)new HttpChunkedInput((ChunkedInput)new ChunkedFile(raf, position, len, 8192), this.getLastHttpContent()), this.endPromise);
            }
        }
        catch (Throwable e) {
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            try {
                this.ctx().channel().close();
            }
            catch (Exception exception) {
            }
            finally {
                ExceptionUtils.throwException((Throwable)e);
            }
        }
    }

    @Override
    ChannelFutureListener closure() {
        return ChannelFutureListener.CLOSE;
    }

    private DefaultHttpResponse buildResponseHead(long contentLength) {
        this.standardHeaders(contentLength, false);
        return new DefaultHttpResponse(((Http1RequestHandleImpl)this.request).req.protocolVersion(), HttpResponseStatus.valueOf((int)this.status), (HttpHeaders)this.headers);
    }

    private void standardHeaders(long contentLength, boolean forceClose) {
        if (this.isKeepAlive && !forceClose) {
            this.headers.remove((CharSequence)HttpHeaderNames.CONNECTION);
        } else {
            this.headers.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
        }
        if (((Http1RequestHandleImpl)this.request).method().equals((Object)HttpMethod.HEAD) || this.status == HttpResponseStatus.NOT_MODIFIED.code()) {
            this.headers.remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
        } else if (contentLength < 0L) {
            if (!this.headers.contains((CharSequence)HttpHeaderNames.TRANSFER_ENCODING) && !this.headers.contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH)) {
                this.headers.set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
            }
        } else {
            this.headers.setLong((CharSequence)HttpHeaderNames.CONTENT_LENGTH, contentLength);
        }
    }

    private boolean supportFileRegion() {
        return this.ctx().pipeline().get(SslHandler.class) == null && this.ctx().pipeline().get(HttpContentCompressor.class) == null;
    }

    private LastHttpContent getLastHttpContent() {
        if (this.isTrailerAbsent()) {
            return LastHttpContent.EMPTY_LAST_CONTENT;
        }
        return new AggregatedLastHttpContent(Unpooled.EMPTY_BUFFER, (HttpHeaders)this.trailers);
    }

    private LastHttpContent getLastHttpContent(ByteBuf data) {
        boolean trailerAbsent = this.isTrailerAbsent();
        if (trailerAbsent && data.readableBytes() == 0) {
            return LastHttpContent.EMPTY_LAST_CONTENT;
        }
        return new AggregatedLastHttpContent(data, (HttpHeaders)(trailerAbsent ? EmptyHttpHeaders.INSTANCE : this.trailers));
    }

    private boolean isTrailerAbsent() {
        return this.trailers == null || this.trailers.isEmpty();
    }

    private boolean inEventLoop() {
        return this.ctx().channel().eventLoop().inEventLoop();
    }

    private void safeRunInChannel(Runnable r, ChannelPromise promise, Object data) {
        Utils.safeRunInChannel(this.ctx(), r, promise, data);
    }
}

