/*
 * Decompiled with CFR 0.152.
 */
package io.github.ferhas.excel_models;

import io.github.ferhas.excel_models.FieldConverterProvider;
import io.github.ferhas.excel_models.annotation.ExcelColumn;
import io.github.ferhas.excel_models.annotation.ExcelObject;
import io.github.ferhas.excel_models.converter.FieldConverter;
import io.github.ferhas.excel_models.exception.ExcelFieldParseException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;

abstract class ExcelUtils {
    ExcelUtils() {
    }

    public static <E> Map<Annotation, Field> getFieldMap(Class<E> type, boolean isExport) {
        HashMap<Annotation, Field> fieldMap = new HashMap<Annotation, Field>();
        for (Field field : type.getDeclaredFields()) {
            Annotation annotation;
            if (field.isAnnotationPresent(ExcelColumn.class)) {
                field.setAccessible(true);
                annotation = field.getAnnotation(ExcelColumn.class);
                if (annotation.onlyExport() && !isExport) continue;
                fieldMap.put(annotation, field);
                continue;
            }
            if (!field.isAnnotationPresent(ExcelObject.class)) continue;
            field.setAccessible(true);
            annotation = field.getAnnotation(ExcelObject.class);
            fieldMap.put(annotation, field);
        }
        if (fieldMap.isEmpty()) {
            throw new IllegalArgumentException(String.format("Model '%s' has not been configured? check if you inserted @%s annotations", type.getSimpleName(), ExcelColumn.class.getSimpleName()));
        }
        return fieldMap;
    }

    static Object getCellValue(Cell cell, Field field, ExcelColumn annotation) {
        Object value;
        switch (cell.getCellType()) {
            case ERROR: 
            case FORMULA: {
                return null;
            }
            case NUMERIC: {
                value = cell.getNumericCellValue();
                break;
            }
            case BOOLEAN: {
                value = cell.getBooleanCellValue();
                break;
            }
            case STRING: {
                value = cell.getStringCellValue();
                break;
            }
            default: {
                value = null;
            }
        }
        return ExcelUtils.tryConvert(field, annotation, value);
    }

    private static Object tryConvert(Field field, ExcelColumn annotation, Object value) {
        Class fieldType = field.getType().isEnum() ? Enum.class : field.getType();
        FieldConverter<?> fieldConverter = FieldConverterProvider.converters.get(fieldType);
        try {
            return fieldConverter != null ? fieldConverter.tryParse(field, annotation, value) : value;
        }
        catch (Exception e) {
            if (!annotation.suppressErrors()) {
                throw new ExcelFieldParseException(String.format("Failed to parse '%s' into field '%s.%s'", value, field.getDeclaringClass().getSimpleName(), field.getName()), e);
            }
            if (annotation.defaultInvalidValues()) {
                return fieldConverter.getDefaultValue();
            }
            return null;
        }
    }
}

