/*
 * Decompiled with CFR 0.152.
 */
package io.github.ferhas.excel_models;

import jakarta.validation.ConstraintViolation;
import jakarta.validation.Validation;
import jakarta.validation.ValidationException;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.util.Set;

class ExcelReaderValidator {
    private final ValidatorFactory factory = Validation.buildDefaultValidatorFactory();

    public <T> void validate(T model) {
        try (ValidatorFactory factory = Validation.buildDefaultValidatorFactory();){
            Validator validator = factory.getValidator();
            Set violations = validator.validate(model, new Class[0]);
            if (!violations.isEmpty()) {
                ConstraintViolation violation = (ConstraintViolation)violations.iterator().next();
                throw new ValidationException(String.format("field '%s' (%s): %s", violation.getPropertyPath().toString(), violation.getInvalidValue(), violation.getMessage()));
            }
        }
    }

    public void close() {
        this.factory.close();
    }
}

