/*
 * Decompiled with CFR 0.152.
 */
package io.github.ferhas.excel_models;

import io.github.ferhas.excel_models.FieldConverterProvider;
import io.github.ferhas.excel_models.annotation.ExcelColumn;
import io.github.ferhas.excel_models.annotation.ExcelObject;
import io.github.ferhas.excel_models.config.ExcelWriterConfig;
import io.github.ferhas.excel_models.converter.FieldConverter;
import io.github.ferhas.excel_models.exception.ExcelModelException;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public final class ExcelWriter {
    private final ExcelWriterConfig config;

    public ExcelWriter() {
        this(new ExcelWriterConfig());
    }

    public ExcelWriter(ExcelWriterConfig config) {
        this.config = config;
    }

    public <T> OutputStream write(@NonNull Collection<T> models) {
        if (models == null) {
            throw new NullPointerException("models is marked non-null but is null");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.write(models, byteArrayOutputStream);
        return byteArrayOutputStream;
    }

    public <T> void write(@NonNull Collection<T> models, @NonNull OutputStream outputStream) {
        if (models == null) {
            throw new NullPointerException("models is marked non-null but is null");
        }
        if (outputStream == null) {
            throw new NullPointerException("outputStream is marked non-null but is null");
        }
        if (models.isEmpty()) {
            return;
        }
        try (XSSFWorkbook workbook = new XSSFWorkbook();){
            Sheet sheet;
            Sheet sheet2 = sheet = this.config.getSheetName() != null ? workbook.createSheet(this.config.getSheetName()) : workbook.createSheet();
            if (this.config.getHeaderBuilder() != null) {
                this.config.getHeaderBuilder().accept((Workbook)workbook, sheet);
            } else {
                CellStyle cellStyle = this.config.getHeaderStyleBuilder() != null ? this.config.getHeaderStyleBuilder().apply((Workbook)workbook) : null;
                Row headerRow = sheet.createRow(sheet.getPhysicalNumberOfRows());
                this.writeHeader(headerRow, cellStyle, models.iterator().next());
            }
            int currentRowIndex = sheet.getPhysicalNumberOfRows();
            for (Object model : models) {
                Row row = sheet.createRow(currentRowIndex++);
                CellStyle cellStyle = this.config.getContentRowStyleBuilder().apply((Workbook)workbook, row.getRowNum());
                this.writeModel(model, row, cellStyle);
                row.setHeight((short)-1);
            }
            if (this.config.getFooterBuilder() != null) {
                this.config.getFooterBuilder().accept((Workbook)workbook, sheet);
            }
            for (int i = 0; i < sheet.getRow(0).getLastCellNum(); ++i) {
                sheet.autoSizeColumn(i, true);
            }
            workbook.write(outputStream);
        }
        catch (Exception e) {
            throw new ExcelModelException("An error occurred while writing file.", e);
        }
    }

    private <T> void writeHeader(Row row, CellStyle cellStyle, T model) throws Exception {
        Map<Annotation, Field> fieldMap = FieldConverterProvider.getFieldMap(Class.forName(model.getClass().getTypeName()), true);
        for (Map.Entry<Annotation, Field> entry : fieldMap.entrySet()) {
            if (entry.getKey() instanceof ExcelColumn) {
                ExcelColumn annotation = (ExcelColumn)entry.getKey();
                Field field = entry.getValue();
                Cell cell = row.createCell(annotation.index() - 1);
                String headerTitle = annotation.title() == null || annotation.title().isBlank() ? StringUtils.capitalize((String)StringUtils.join((Object[])StringUtils.splitByCharacterTypeCamelCase((String)field.getName()), (String)" ")) : annotation.title();
                cell.setCellValue(headerTitle);
                if (cellStyle == null) continue;
                cell.setCellStyle(cellStyle);
                continue;
            }
            if (!(entry.getKey() instanceof ExcelObject)) continue;
            Field field = entry.getValue();
            this.writeHeader(row, cellStyle, field.get(model));
        }
    }

    private <T> void writeModel(T model, Row row, CellStyle cellStyle) throws Exception {
        Map<Annotation, Field> fieldMap = FieldConverterProvider.getFieldMap(Class.forName(model.getClass().getTypeName()), true);
        for (Map.Entry<Annotation, Field> entry : fieldMap.entrySet()) {
            if (entry.getKey() instanceof ExcelColumn) {
                ExcelColumn annotation = (ExcelColumn)entry.getKey();
                Field field = entry.getValue();
                Cell cell = row.createCell(annotation.index() - 1);
                cell.setCellStyle(cellStyle);
                Object value = field.get(model);
                FieldConverter<?> fieldConverter = FieldConverterProvider.getFieldConverter(field);
                String cellValue = null;
                if (fieldConverter != null) {
                    cellValue = fieldConverter.toExcelValue(value);
                } else if (value != null) {
                    cellValue = value.toString();
                }
                cell.setCellValue(cellValue);
                continue;
            }
            if (!(entry.getKey() instanceof ExcelObject)) continue;
            Field field = entry.getValue();
            this.writeModel(field.get(model), row, cellStyle);
        }
    }
}

