/*
 * Decompiled with CFR 0.152.
 */
package io.github.ferhas.excel_models.config;

import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class ExcelWriterConfig {
    private String sheetName;
    private BiConsumer<Workbook, Sheet> headerBuilder;
    private BiConsumer<Workbook, Sheet> footerBuilder;
    private Function<Workbook, CellStyle> headerStyleBuilder = workbook -> {
        Font font = workbook.createFont();
        font.setBold(true);
        CellStyle cellStyle = workbook.createCellStyle();
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cellStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        cellStyle.setFont(font);
        return cellStyle;
    };
    private BiFunction<Workbook, Integer, CellStyle> contentRowStyleBuilder = (workbook, integer) -> {
        CellStyle cellStyle = workbook.createCellStyle();
        cellStyle.setWrapText(true);
        return cellStyle;
    };

    public String getSheetName() {
        return this.sheetName;
    }

    public BiConsumer<Workbook, Sheet> getHeaderBuilder() {
        return this.headerBuilder;
    }

    public BiConsumer<Workbook, Sheet> getFooterBuilder() {
        return this.footerBuilder;
    }

    public Function<Workbook, CellStyle> getHeaderStyleBuilder() {
        return this.headerStyleBuilder;
    }

    public BiFunction<Workbook, Integer, CellStyle> getContentRowStyleBuilder() {
        return this.contentRowStyleBuilder;
    }

    public ExcelWriterConfig setSheetName(String sheetName) {
        this.sheetName = sheetName;
        return this;
    }

    public ExcelWriterConfig setHeaderBuilder(BiConsumer<Workbook, Sheet> headerBuilder) {
        this.headerBuilder = headerBuilder;
        return this;
    }

    public ExcelWriterConfig setFooterBuilder(BiConsumer<Workbook, Sheet> footerBuilder) {
        this.footerBuilder = footerBuilder;
        return this;
    }

    public ExcelWriterConfig setHeaderStyleBuilder(Function<Workbook, CellStyle> headerStyleBuilder) {
        this.headerStyleBuilder = headerStyleBuilder;
        return this;
    }

    public ExcelWriterConfig setContentRowStyleBuilder(BiFunction<Workbook, Integer, CellStyle> contentRowStyleBuilder) {
        this.contentRowStyleBuilder = contentRowStyleBuilder;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExcelWriterConfig)) {
            return false;
        }
        ExcelWriterConfig other = (ExcelWriterConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$sheetName = this.getSheetName();
        String other$sheetName = other.getSheetName();
        if (this$sheetName == null ? other$sheetName != null : !this$sheetName.equals(other$sheetName)) {
            return false;
        }
        BiConsumer<Workbook, Sheet> this$headerBuilder = this.getHeaderBuilder();
        BiConsumer<Workbook, Sheet> other$headerBuilder = other.getHeaderBuilder();
        if (this$headerBuilder == null ? other$headerBuilder != null : !this$headerBuilder.equals(other$headerBuilder)) {
            return false;
        }
        BiConsumer<Workbook, Sheet> this$footerBuilder = this.getFooterBuilder();
        BiConsumer<Workbook, Sheet> other$footerBuilder = other.getFooterBuilder();
        if (this$footerBuilder == null ? other$footerBuilder != null : !this$footerBuilder.equals(other$footerBuilder)) {
            return false;
        }
        Function<Workbook, CellStyle> this$headerStyleBuilder = this.getHeaderStyleBuilder();
        Function<Workbook, CellStyle> other$headerStyleBuilder = other.getHeaderStyleBuilder();
        if (this$headerStyleBuilder == null ? other$headerStyleBuilder != null : !this$headerStyleBuilder.equals(other$headerStyleBuilder)) {
            return false;
        }
        BiFunction<Workbook, Integer, CellStyle> this$contentRowStyleBuilder = this.getContentRowStyleBuilder();
        BiFunction<Workbook, Integer, CellStyle> other$contentRowStyleBuilder = other.getContentRowStyleBuilder();
        return !(this$contentRowStyleBuilder == null ? other$contentRowStyleBuilder != null : !this$contentRowStyleBuilder.equals(other$contentRowStyleBuilder));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExcelWriterConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $sheetName = this.getSheetName();
        result = result * 59 + ($sheetName == null ? 43 : $sheetName.hashCode());
        BiConsumer<Workbook, Sheet> $headerBuilder = this.getHeaderBuilder();
        result = result * 59 + ($headerBuilder == null ? 43 : $headerBuilder.hashCode());
        BiConsumer<Workbook, Sheet> $footerBuilder = this.getFooterBuilder();
        result = result * 59 + ($footerBuilder == null ? 43 : $footerBuilder.hashCode());
        Function<Workbook, CellStyle> $headerStyleBuilder = this.getHeaderStyleBuilder();
        result = result * 59 + ($headerStyleBuilder == null ? 43 : $headerStyleBuilder.hashCode());
        BiFunction<Workbook, Integer, CellStyle> $contentRowStyleBuilder = this.getContentRowStyleBuilder();
        result = result * 59 + ($contentRowStyleBuilder == null ? 43 : $contentRowStyleBuilder.hashCode());
        return result;
    }

    public String toString() {
        return "ExcelWriterConfig(sheetName=" + this.getSheetName() + ", headerBuilder=" + this.getHeaderBuilder() + ", footerBuilder=" + this.getFooterBuilder() + ", headerStyleBuilder=" + this.getHeaderStyleBuilder() + ", contentRowStyleBuilder=" + this.getContentRowStyleBuilder() + ")";
    }

    public ExcelWriterConfig withSheetName(String sheetName) {
        return this.sheetName == sheetName ? this : new ExcelWriterConfig(sheetName, this.headerBuilder, this.footerBuilder, this.headerStyleBuilder, this.contentRowStyleBuilder);
    }

    public ExcelWriterConfig withHeaderBuilder(BiConsumer<Workbook, Sheet> headerBuilder) {
        return this.headerBuilder == headerBuilder ? this : new ExcelWriterConfig(this.sheetName, headerBuilder, this.footerBuilder, this.headerStyleBuilder, this.contentRowStyleBuilder);
    }

    public ExcelWriterConfig withFooterBuilder(BiConsumer<Workbook, Sheet> footerBuilder) {
        return this.footerBuilder == footerBuilder ? this : new ExcelWriterConfig(this.sheetName, this.headerBuilder, footerBuilder, this.headerStyleBuilder, this.contentRowStyleBuilder);
    }

    public ExcelWriterConfig withHeaderStyleBuilder(Function<Workbook, CellStyle> headerStyleBuilder) {
        return this.headerStyleBuilder == headerStyleBuilder ? this : new ExcelWriterConfig(this.sheetName, this.headerBuilder, this.footerBuilder, headerStyleBuilder, this.contentRowStyleBuilder);
    }

    public ExcelWriterConfig withContentRowStyleBuilder(BiFunction<Workbook, Integer, CellStyle> contentRowStyleBuilder) {
        return this.contentRowStyleBuilder == contentRowStyleBuilder ? this : new ExcelWriterConfig(this.sheetName, this.headerBuilder, this.footerBuilder, this.headerStyleBuilder, contentRowStyleBuilder);
    }

    public ExcelWriterConfig() {
    }

    public ExcelWriterConfig(String sheetName, BiConsumer<Workbook, Sheet> headerBuilder, BiConsumer<Workbook, Sheet> footerBuilder, Function<Workbook, CellStyle> headerStyleBuilder, BiFunction<Workbook, Integer, CellStyle> contentRowStyleBuilder) {
        this.sheetName = sheetName;
        this.headerBuilder = headerBuilder;
        this.footerBuilder = footerBuilder;
        this.headerStyleBuilder = headerStyleBuilder;
        this.contentRowStyleBuilder = contentRowStyleBuilder;
    }
}

