/*
 * Decompiled with CFR 0.152.
 */
package io.fi0x.javaconsolegraph;

import java.util.Arrays;

class ConsoleGraph {
    String xAxisName = "x";
    String yAxisName = "y";
    double xMin;
    double yMin;
    double scaleX = 1.0;
    double scaleY = 1.0;
    int xSize;
    int ySize;

    ConsoleGraph() {
    }

    void updateOutline(String[][] currentGraph) {
        currentGraph[0][0] = this.yAxisName;
        for (int rowCount = 2; rowCount < currentGraph[0].length; ++rowCount) {
            currentGraph[0][currentGraph[0].length - rowCount] = "" + (this.yMin + this.scaleY * (double)(rowCount - 2));
        }
        for (int columnCount = 1; columnCount < currentGraph.length - 1; ++columnCount) {
            currentGraph[columnCount][currentGraph[0].length - 1] = "" + (this.xMin + this.scaleX * (double)columnCount - 1.0);
        }
        currentGraph[currentGraph.length - 1][currentGraph[0].length - 1] = this.xAxisName;
    }

    String[][] getBlankGraph() {
        String[][] layout;
        for (Object[] objectArray : layout = new String[this.xSize + 2][this.ySize + 2]) {
            Arrays.fill(objectArray, "");
        }
        return layout;
    }

    void fillInValues(String[][] graph, double[] values) {
        for (int i = 0; i < values.length; ++i) {
            graph[i + 1][graph[0].length - this.getBestY((double)values[i]) - 2] = "" + values[i];
        }
    }

    private int getBestY(double value) {
        int idx = (int)((value /= this.scaleY) + 0.5);
        if (idx < 0) {
            idx = 0;
        }
        if (idx >= this.ySize) {
            idx = this.ySize - 1;
        }
        return idx;
    }
}

