/*
 * Decompiled with CFR 0.152.
 */
package io.fi0x.javadatastructures;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AvgList {
    private List<Double> originalList;
    private List<Double> averagedList = new ArrayList<Double>();
    private Double highestValue = null;
    private Double lowestValue = null;
    private boolean preCalculate = false;
    private boolean dirty = false;
    private Double topCutoff = null;
    private Double lowCutoff = null;
    private Double topCutoffPercent = null;
    private Double lowCutoffPercent = null;
    private int additionalAveragingValues = 0;

    public AvgList() {
        this.originalList = new ArrayList<Double>();
    }

    public AvgList(List<Double> initialList) {
        this.originalList = List.copyOf(initialList);
        this.dirty = true;
        this.averagedList = List.copyOf(initialList);
    }

    public void setData(List<Double> data) {
        this.originalList = data;
        this.dirty = true;
        if (this.preCalculate) {
            this.reCalculate();
        }
    }

    public void add(double value) {
        this.originalList.add(value);
        this.dirty = true;
        if (this.preCalculate) {
            this.reCalculate();
        }
    }

    public Double remove(int index) {
        Double value = this.originalList.remove(index);
        this.dirty = true;
        if (this.preCalculate) {
            this.reCalculate();
        }
        return value;
    }

    public void setPreCalculate(boolean preCalculate) {
        this.preCalculate = preCalculate;
        if (preCalculate) {
            this.reCalculate();
        }
    }

    public void setTopCutoff(Double topCutoff) {
        this.topCutoff = topCutoff;
        this.dirty = true;
        if (this.preCalculate) {
            this.reCalculate();
        }
    }

    public void setLowCutoff(Double lowCutoff) {
        this.lowCutoff = lowCutoff;
        this.dirty = true;
        if (this.preCalculate) {
            this.reCalculate();
        }
    }

    public void setTopCutoffPercent(Double topCutoffPercent) {
        if (topCutoffPercent != null && (topCutoffPercent < 0.0 || topCutoffPercent > 100.0)) {
            throw new IllegalArgumentException("topCutoffPercent must be at least 0 and at most 100");
        }
        this.topCutoffPercent = topCutoffPercent;
        this.dirty = true;
        if (this.preCalculate) {
            this.reCalculate();
        }
    }

    public void setLowCutoffPercent(Double lowCutoffPercent) {
        if (lowCutoffPercent != null && (lowCutoffPercent < 0.0 || lowCutoffPercent > 100.0)) {
            throw new IllegalArgumentException("lowCutoffPercent must be at least 0 and at most 100");
        }
        this.lowCutoffPercent = lowCutoffPercent;
        this.dirty = true;
        if (this.preCalculate) {
            this.reCalculate();
        }
    }

    public void setAdditionalAveragingValues(int additionalAveragingValues) {
        this.additionalAveragingValues = additionalAveragingValues;
        this.dirty = true;
        if (this.preCalculate) {
            this.reCalculate();
        }
    }

    public List<Double> getOriginalList() {
        return this.originalList;
    }

    public List<Double> get() {
        if (!this.preCalculate) {
            this.reCalculate();
        }
        return this.averagedList;
    }

    public void reCalculate() {
        if (this.dirty) {
            List<Double> adjustedList = this.removeCutoffs();
            if (this.additionalAveragingValues == 0) {
                this.averagedList = List.copyOf(adjustedList);
            } else {
                this.averageList(adjustedList);
            }
            this.dirty = false;
        }
    }

    private List<Double> removeCutoffs() {
        this.highestValue = this.getHighestValue();
        this.lowestValue = this.getLowestValue();
        ArrayList<Double> adjustedList = new ArrayList<Double>();
        Double highCutoff = this.topCutoff;
        Double highPercent = this.absoluteFromPercentage(100.0 - this.topCutoffPercent);
        if (highCutoff != null || highPercent != null) {
            if (highCutoff == null) {
                highCutoff = highPercent;
            } else if (highPercent != null) {
                highCutoff = Math.min(highCutoff, highPercent);
            }
        } else {
            highCutoff = this.highestValue;
        }
        Double minCutoff = this.lowCutoff;
        Double minPercent = this.absoluteFromPercentage(this.lowCutoffPercent);
        if (minCutoff != null || minPercent != null) {
            if (minCutoff == null) {
                minCutoff = minPercent;
            } else if (minPercent != null) {
                minCutoff = Math.min(minCutoff, minPercent);
            }
        } else {
            minCutoff = this.lowestValue;
        }
        for (Double value : this.originalList) {
            if (!(value < highCutoff) || !(value > minCutoff)) continue;
            adjustedList.add(value);
        }
        return adjustedList;
    }

    private Double absoluteFromPercentage(Double percent) {
        if (percent == null || this.highestValue == null || this.lowestValue == null) {
            return null;
        }
        double range = this.highestValue - this.lowestValue;
        double percentAbsolute = range / 100.0 * percent;
        return percentAbsolute + this.lowestValue;
    }

    private Double getHighestValue() {
        if (this.originalList.isEmpty()) {
            return null;
        }
        return Collections.max(this.originalList);
    }

    private Double getLowestValue() {
        if (this.originalList.isEmpty()) {
            return null;
        }
        return Collections.min(this.originalList);
    }

    private void averageList(List<Double> inputList) {
        this.averagedList = List.copyOf(inputList);
        if (this.averagedList.isEmpty()) {
            return;
        }
        for (int idx = 0; idx < inputList.size(); ++idx) {
            double amount = 0.0;
            double sum = 0.0;
            for (int aIdx = Math.max(0, idx - this.additionalAveragingValues); aIdx < inputList.size() && aIdx <= idx + this.additionalAveragingValues; ++aIdx) {
                amount += 1.0;
                sum += inputList.get(aIdx).doubleValue();
            }
            this.averagedList.set(idx, sum / amount);
        }
    }
}

