/*
 * Decompiled with CFR 0.152.
 */
package io.fi0x.javalogger;

import io.fi0x.javalogger.Logger;
import java.util.HashMap;
import java.util.Map;

public class LogSettings {
    static final String RESET = "\u001b[0m";
    public static final String RED = "\u001b[31m";
    public static final String GREEN = "\u001b[32m";
    public static final String YELLOW = "\u001b[33m";
    public static final String BLUE = "\u001b[34m";
    public static final String PURPLE = "\u001b[35m";
    public static final String CYAN = "\u001b[36m";
    public static final String WHITE = "\u001b[37m";
    static Map<String, Logger.LOG> defaultSettings = new HashMap<String, Logger.LOG>(){
        {
            this.put("verbose", new Logger.LOG(null).COLOR(LogSettings.WHITE).LEVEL(Logger.LEVEL.VER).FILE_ENTRY(false).DEBUG(false).VERBOSE(true));
            this.put("info", new Logger.LOG(null).COLOR(LogSettings.WHITE).LEVEL(Logger.LEVEL.INF).FILE_ENTRY(true).DEBUG(true).VERBOSE(true));
            this.put("warning", new Logger.LOG(null).COLOR(LogSettings.YELLOW).LEVEL(Logger.LEVEL.WRN).FILE_ENTRY(true).DEBUG(false).VERBOSE(false));
            this.put("error", new Logger.LOG(null).COLOR(LogSettings.RED).LEVEL(Logger.LEVEL.ERR).FILE_ENTRY(true).DEBUG(false).VERBOSE(false));
        }
    };

    public static boolean createNewTemplate(String templateName, String colorCode, Logger.LEVEL logLevel, boolean writeToFile, boolean onlyDebug, boolean onlyVerbose) {
        if (defaultSettings.containsKey(templateName)) {
            return false;
        }
        defaultSettings.put(templateName, new Logger.LOG(null).COLOR(colorCode).LEVEL(logLevel).FILE_ENTRY(writeToFile).DEBUG(onlyDebug).VERBOSE(onlyVerbose));
        return true;
    }

    public static Logger.LOG getLOGFromTemplate(String text, String templateName) {
        if (!defaultSettings.containsKey(templateName)) {
            return null;
        }
        return Logger.LOG.copyLogSettings(text, defaultSettings.get(templateName));
    }
}

