/*
 * Decompiled with CFR 0.152.
 */
package io.fi0x.javalogger;

import io.fi0x.javalogger.LogSettings;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;

public class Logger {
    private static Logger instance;
    private File logFolder = new File(System.getenv("PROGRAMDATA") + File.separator + "JavaLogger");
    private File currentLogFile = new File(this.logFolder.getPath() + File.separator + Logger.getLogFileDate() + ".log");
    private boolean isDebug;
    private boolean isVerbose;
    private boolean smallLog;

    private Logger() {
    }

    public static Logger getInstance() {
        if (instance == null) {
            instance = new Logger();
        }
        return instance;
    }

    public void setLogFolder(File logFolder) {
        this.logFolder = logFolder;
        this.currentLogFile = new File(logFolder.getPath() + File.separator + Logger.getLogFileDate() + ".log");
    }

    public void setDebug(boolean isDebugMode) {
        this.isDebug = isDebugMode;
    }

    public void setVerbose(boolean isVerboseMode) {
        this.isVerbose = isVerboseMode;
    }

    public void setSmallLog(boolean ignorePrefixes) {
        this.smallLog = ignorePrefixes;
    }

    public static void VERBOSE(String text) {
        Logger.getInstance().log(Objects.requireNonNull(LogSettings.getLOGFromTemplate(text, "verbose")));
    }

    public static void INFO(String text) {
        Logger.getInstance().log(Objects.requireNonNull(LogSettings.getLOGFromTemplate(text, "info")));
    }

    public static void WARNING(String text) {
        Logger.getInstance().log(Objects.requireNonNull(LogSettings.getLOGFromTemplate(text, "warning")));
    }

    public static void ERROR(String text) {
        Logger.getInstance().log(Objects.requireNonNull(LogSettings.getLOGFromTemplate(text, "error")));
    }

    public void log(LOG log) {
        if (log.onlyDebug && this.isDebug || log.onlyVerbose && this.isVerbose || !log.onlyVerbose && !log.onlyDebug) {
            String logOutput = Logger.createLogString(log);
            System.out.println(log.color + logOutput + "\u001b[0m");
            if (log.fileEntry) {
                if (!this.currentLogFile.exists()) {
                    this.createLogFile();
                }
                try {
                    ArrayList<String> fileContent = new ArrayList<String>(Files.readAllLines(this.currentLogFile.toPath(), StandardCharsets.UTF_8));
                    fileContent.add(logOutput);
                    if (log.exception != null) {
                        fileContent.add("\t" + Arrays.toString(log.exception.getStackTrace()).replace(", ", "\n\t").replace("[", "").replace("]", ""));
                    }
                    Files.write(this.currentLogFile.toPath(), fileContent, StandardCharsets.UTF_8, new OpenOption[0]);
                }
                catch (IOException e) {
                    System.out.println("\u001b[31mSomething went wrong when writing to the log-file\u001b[0m");
                }
            }
        }
    }

    public boolean log(String text, String templateName) {
        LOG l = LogSettings.getLOGFromTemplate(text, templateName);
        if (l == null) {
            return false;
        }
        this.log(l);
        return true;
    }

    private static String createLogString(LOG log) {
        if (log.plainText || Logger.getInstance().smallLog) {
            return log.message;
        }
        String errorCode = log.errorCode == 0 ? "[---]" : "[" + log.errorCode + "]";
        String prefix = "[" + (Object)((Object)log.loglevel) + "]";
        return Logger.getLogEntryDate() + prefix + errorCode + log.message;
    }

    private static String getLogEntryDate() {
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss");
        LocalDateTime now = LocalDateTime.now();
        return "[" + dtf.format(now) + "]";
    }

    private static String getLogFileDate() {
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm-ss");
        LocalDateTime now = LocalDateTime.now();
        return dtf.format(now);
    }

    private void createLogFile() {
        LOG l;
        try {
            Files.createDirectories(this.logFolder.toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            l = new LOG("Could not create log-directory: " + this.logFolder).COLOR("\u001b[31m").LEVEL(LEVEL.ERR).CODE(0).EXCEPTION(e).FILE_ENTRY(false);
            this.log(l);
        }
        try {
            this.currentLogFile.createNewFile();
        }
        catch (IOException e) {
            l = new LOG("Could not create file: " + this.currentLogFile).COLOR("\u001b[31m").LEVEL(LEVEL.ERR).CODE(0).EXCEPTION(e).FILE_ENTRY(false);
            this.log(l);
        }
    }

    public static enum LEVEL {
        VER,
        INF,
        WRN,
        ERR;

    }

    public static class LOG {
        private final String message;
        private String color = "\u001b[0m";
        private LEVEL loglevel = LEVEL.INF;
        private int errorCode = 0;
        private Exception exception = null;
        private boolean fileEntry = true;
        private boolean onlyVerbose = false;
        private boolean onlyDebug = false;
        private boolean plainText = false;

        public LOG(String text) {
            this.message = text;
        }

        public LOG COLOR(String colorCode) {
            this.color = colorCode;
            return this;
        }

        public LOG LEVEL(LEVEL levelEnum) {
            this.loglevel = levelEnum;
            return this;
        }

        public LOG CODE(int exceptionCode) {
            this.errorCode = exceptionCode;
            return this;
        }

        public LOG EXCEPTION(Exception e) {
            this.exception = e;
            return this;
        }

        public LOG FILE_ENTRY(boolean shouldWriteToFile) {
            this.fileEntry = shouldWriteToFile;
            return this;
        }

        public LOG DEBUG(boolean onlyInDebugMode) {
            this.onlyDebug = onlyInDebugMode;
            return this;
        }

        public LOG VERBOSE(boolean onlyInVerboseMode) {
            this.onlyVerbose = onlyInVerboseMode;
            return this;
        }

        public LOG PLAINTEXT(boolean onlyPlaintext) {
            this.plainText = onlyPlaintext;
            return this;
        }

        static LOG copyLogSettings(String text, LOG original) {
            return new LOG(text).COLOR(original.color).LEVEL(original.loglevel).FILE_ENTRY(original.fileEntry).DEBUG(original.onlyDebug).VERBOSE(original.onlyVerbose).PLAINTEXT(original.plainText);
        }
    }
}

