/*
 * Decompiled with CFR 0.152.
 */
package io.fi0x.javalogger.logging;

public class LogColor {
    public static final String RESET = "\u001b[0m";
    public static final String BLACK = "\u001b[0;30m";
    public static final String RED = "\u001b[0;31m";
    public static final String GREEN = "\u001b[0;32m";
    public static final String YELLOW = "\u001b[0;33m";
    public static final String BLUE = "\u001b[0;34m";
    public static final String PURPLE = "\u001b[0;35m";
    public static final String CYAN = "\u001b[0;36m";
    public static final String WHITE = "\u001b[0;37m";
    public static final String BLACK_BRIGHT = "\u001b[0;90m";
    public static final String RED_BRIGHT = "\u001b[0;91m";
    public static final String GREEN_BRIGHT = "\u001b[0;92m";
    public static final String YELLOW_BRIGHT = "\u001b[0;93m";
    public static final String BLUE_BRIGHT = "\u001b[0;94m";
    public static final String PURPLE_BRIGHT = "\u001b[0;95m";
    public static final String CYAN_BRIGHT = "\u001b[0;96m";
    public static final String WHITE_BRIGHT = "\u001b[0;97m";
    public static final String BLACK_BACKGROUND = "\u001b[40m";
    public static final String RED_BACKGROUND = "\u001b[41m";
    public static final String GREEN_BACKGROUND = "\u001b[42m";
    public static final String YELLOW_BACKGROUND = "\u001b[43m";
    public static final String BLUE_BACKGROUND = "\u001b[44m";
    public static final String PURPLE_BACKGROUND = "\u001b[45m";
    public static final String CYAN_BACKGROUND = "\u001b[46m";
    public static final String WHITE_BACKGROUND = "\u001b[47m";
    public static final String BLACK_BACKGROUND_BRIGHT = "\u001b[100m";
    public static final String RED_BACKGROUND_BRIGHT = "\u001b[101m";
    public static final String GREEN_BACKGROUND_BRIGHT = "\u001b[102m";
    public static final String YELLOW_BACKGROUND_BRIGHT = "\u001b[103m";
    public static final String BLUE_BACKGROUND_BRIGHT = "\u001b[104m";
    public static final String PURPLE_BACKGROUND_BRIGHT = "\u001b[105m";
    public static final String CYAN_BACKGROUND_BRIGHT = "\u001b[106m";
    public static final String WHITE_BACKGROUND_BRIGHT = "\u001b[107m";

    private LogColor() {
    }

    public static String get(Color color, Design design, boolean bright, boolean foreground) {
        Object result = "\u001b[";
        if (foreground) {
            result = (String)result + design.style + ";";
        }
        int colorNumber = color.id;
        if (bright) {
            colorNumber += 60;
        }
        result = (String)result + colorNumber + "m";
        return result;
    }

    public static String get(Color color, Design design, boolean bright) {
        return LogColor.get(color, design, bright, true);
    }

    public static String get(Color color, Design design) {
        return LogColor.get(color, design, false);
    }

    public static String get(Color color) {
        return LogColor.get(color, Design.NORMAL);
    }

    public static enum Design {
        NORMAL(0),
        BOLD(1),
        ITALIC(3),
        UNDERLINED(4),
        INVERTED(7),
        STRIKETHROUGH(9);

        private int style;

        private Design(int i) {
            this.style = i;
        }
    }

    public static enum Color {
        BLACK(30),
        RED(31),
        GREEN(32),
        YELLOW(33),
        BLUE(34),
        PURPLE(35),
        CYAN(36),
        WHITE(37);

        private final int id;

        private Color(int i) {
            this.id = i;
        }
    }
}

