/*
 * Decompiled with CFR 0.152.
 */
package com.flyjingfish.module_communication_plugin;

import com.flyjingfish.module_communication_plugin.Dom4jData;
import com.flyjingfish.module_communication_plugin.IncrementalRecord;
import com.flyjingfish.module_communication_plugin.ResValueRecord;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010J\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0015J\u0016\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005J\u0014\u0010\u001b\u001a\u00020\u00172\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\tJ\u0016\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0005J\u0016\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\nR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/flyjingfish/module_communication_plugin/IncrementalRecordUtils;", "", "()V", "exposeAssets", "", "", "lastExposeResFileMap", "", "lastExposeResValueMap", "", "Lcom/flyjingfish/module_communication_plugin/ResValueRecord;", "lastRecordPackageMap", "clearCodeFile", "", "moduleKey", "buildFile", "Ljava/io/File;", "clearResFile", "clearResValue", "getExposeAssets", "getIncrementalRecord", "Lcom/flyjingfish/module_communication_plugin/IncrementalRecord;", "init", "", "incrementalRecord", "recordCodeFile", "packageName", "recordExposeAssets", "ids", "recordResFile", "filePath", "recordResValue", "resValueRecord", "module-communication-plugin"})
public final class IncrementalRecordUtils {
    @NotNull
    public static final IncrementalRecordUtils INSTANCE = new IncrementalRecordUtils();
    @NotNull
    private static final Map<String, Set<String>> lastRecordPackageMap = new LinkedHashMap();
    @NotNull
    private static final Map<String, Set<String>> lastExposeResFileMap = new LinkedHashMap();
    @NotNull
    private static final Map<String, List<ResValueRecord>> lastExposeResValueMap = new LinkedHashMap();
    @NotNull
    private static final Set<String> exposeAssets = new LinkedHashSet();

    private IncrementalRecordUtils() {
    }

    public final void init(@Nullable IncrementalRecord incrementalRecord) {
        if (incrementalRecord != null) {
            Object object;
            if (lastRecordPackageMap.isEmpty() && !((object = incrementalRecord.getLastRecordPackageMap()) == null || object.isEmpty())) {
                lastRecordPackageMap.putAll(incrementalRecord.getLastRecordPackageMap());
            }
            if (lastExposeResFileMap.isEmpty() && !((object = incrementalRecord.getLastExposeResFileMap()) == null || object.isEmpty())) {
                lastExposeResFileMap.putAll(incrementalRecord.getLastExposeResFileMap());
            }
            if (lastExposeResValueMap.isEmpty() && !((object = incrementalRecord.getLastExposeResValueMap()) == null || object.isEmpty())) {
                lastExposeResValueMap.putAll(incrementalRecord.getLastExposeResValueMap());
            }
            if (exposeAssets.isEmpty() && !((object = (Collection)incrementalRecord.getExposeAssets()) == null || object.isEmpty())) {
                exposeAssets.addAll((Collection<String>)incrementalRecord.getExposeAssets());
            }
        }
    }

    @NotNull
    public final IncrementalRecord getIncrementalRecord() {
        return new IncrementalRecord(lastRecordPackageMap, lastExposeResFileMap, lastExposeResValueMap, exposeAssets);
    }

    public final void recordResFile(@NotNull String moduleKey, @NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)moduleKey, (String)"moduleKey");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Set lastRecordPackageSet = lastExposeResFileMap.get(moduleKey);
        if (lastRecordPackageSet == null) {
            lastRecordPackageSet = new LinkedHashSet();
            lastExposeResFileMap.put(moduleKey, lastRecordPackageSet);
        }
        lastRecordPackageSet.add((String)filePath);
    }

    public final boolean clearResFile(@NotNull String moduleKey, @NotNull File buildFile) {
        Set<String> lastRecordPackageSet;
        Intrinsics.checkNotNullParameter((Object)moduleKey, (String)"moduleKey");
        Intrinsics.checkNotNullParameter((Object)buildFile, (String)"buildFile");
        Set<String> set = lastRecordPackageSet = lastExposeResFileMap.get(moduleKey);
        if (set != null) {
            Set<String> it = set;
            boolean bl = false;
            for (String filePath : it) {
                File packageFile = new File(buildFile.getAbsolutePath() + '/' + filePath);
                FilesKt.deleteRecursively((File)packageFile);
            }
            it.clear();
        }
        Collection collection2 = lastRecordPackageSet;
        return collection2 == null || collection2.isEmpty();
    }

    public final void recordResValue(@NotNull String moduleKey, @NotNull ResValueRecord resValueRecord) {
        Intrinsics.checkNotNullParameter((Object)moduleKey, (String)"moduleKey");
        Intrinsics.checkNotNullParameter((Object)resValueRecord, (String)"resValueRecord");
        List lastRecordPackageSet = lastExposeResValueMap.get(moduleKey);
        if (lastRecordPackageSet == null) {
            lastRecordPackageSet = new ArrayList();
            lastExposeResValueMap.put(moduleKey, lastRecordPackageSet);
        }
        lastRecordPackageSet.add((ResValueRecord)resValueRecord);
    }

    public final boolean clearResValue(@NotNull String moduleKey, @NotNull File buildFile) {
        List<ResValueRecord> lastRecordPackageSet;
        Intrinsics.checkNotNullParameter((Object)moduleKey, (String)"moduleKey");
        Intrinsics.checkNotNullParameter((Object)buildFile, (String)"buildFile");
        List<ResValueRecord> list = lastRecordPackageSet = lastExposeResValueMap.get(moduleKey);
        if (list != null) {
            List<ResValueRecord> it = list;
            boolean bl = false;
            for (ResValueRecord resValueRecord : it) {
                File xmlFile = resValueRecord.getXmlFile();
                Dom4jData.INSTANCE.deleteElementLabel(xmlFile, resValueRecord.getResValue());
            }
            it.clear();
        }
        Collection collection2 = lastRecordPackageSet;
        return collection2 == null || collection2.isEmpty();
    }

    public final void recordExposeAssets(@NotNull List<String> ids) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        exposeAssets.clear();
        exposeAssets.addAll((Collection<String>)ids);
    }

    @NotNull
    public final Set<String> getExposeAssets() {
        return exposeAssets;
    }

    public final void recordCodeFile(@NotNull String moduleKey, @NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)moduleKey, (String)"moduleKey");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Set lastRecordPackageSet = lastRecordPackageMap.get(moduleKey);
        if (lastRecordPackageSet == null) {
            lastRecordPackageSet = new LinkedHashSet();
            lastRecordPackageMap.put(moduleKey, lastRecordPackageSet);
        }
        lastRecordPackageSet.add((String)packageName);
    }

    public final boolean clearCodeFile(@NotNull String moduleKey, @NotNull File buildFile) {
        Set<String> lastRecordPackageSet;
        Intrinsics.checkNotNullParameter((Object)moduleKey, (String)"moduleKey");
        Intrinsics.checkNotNullParameter((Object)buildFile, (String)"buildFile");
        Set<String> set = lastRecordPackageSet = lastRecordPackageMap.get(moduleKey);
        if (set != null) {
            Set<String> it = set;
            boolean bl = false;
            for (String packageName : it) {
                File packageFile = new File(buildFile.getAbsolutePath() + '/' + StringsKt.replace$default((String)packageName, (String)".", (String)"/", (boolean)false, (int)4, null));
                FilesKt.deleteRecursively((File)packageFile);
            }
            it.clear();
        }
        Collection collection2 = lastRecordPackageSet;
        return collection2 == null || collection2.isEmpty();
    }
}

