/*
 * Decompiled with CFR 0.152.
 */
package com.flyjingfish.module_communication_plugin;

import com.android.build.api.variant.Variant;
import com.android.build.gradle.internal.coverage.JacocoReportTask;
import com.flyjingfish.module_communication_plugin.IncrementalRecord;
import com.flyjingfish.module_communication_plugin.IncrementalRecordUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ+\u0010\u000e\u001a\u0004\u0018\u0001H\u000f\"\u0004\b\u0000\u0010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0013H\u0002\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0001H\u0002J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0011H\u0002J\u0018\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0011H\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/flyjingfish/module_communication_plugin/TmpUtils;", "", "()V", "buildConfigCacheFile", "Ljava/io/File;", "gson", "Lcom/google/gson/Gson;", "exportTmp", "", "initTmp", "project", "Lorg/gradle/api/Project;", "variant", "Lcom/android/build/api/variant/Variant;", "optFromJsonString", "T", "jsonString", "", "clazz", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "optToJsonString", "any", "readAsString", "path", "saveFile", "file", "data", "temporaryDirMkdirs", "", "module-communication-plugin"})
public final class TmpUtils {
    @NotNull
    public static final TmpUtils INSTANCE = new TmpUtils();
    private static File buildConfigCacheFile;
    @NotNull
    private static final Gson gson;

    private TmpUtils() {
    }

    private final <T> T optFromJsonString(String jsonString, Class<T> clazz) {
        try {
            return (T)gson.fromJson(jsonString, clazz);
        }
        catch (Throwable e) {
            JacocoReportTask.JacocoReportWorkerAction.Companion.getLogger().warn("optFromJsonString(" + jsonString + ", " + clazz, e);
            return null;
        }
    }

    private final String optToJsonString(Object any) {
        try {
            String string = gson.toJson(any);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gson.toJson(any)");
            return string;
        }
        catch (Throwable throwable) {
            JacocoReportTask.JacocoReportWorkerAction.Companion.getLogger().warn("optToJsonString(" + any, throwable);
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void saveFile(File file, String data) {
        this.temporaryDirMkdirs();
        try (FileOutputStream fos = new FileOutputStream(file.getAbsolutePath());){
            String string = data;
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            fos.write(byArray);
        }
    }

    private final String readAsString(String path) {
        String string;
        try {
            byte[] byArray = Files.readAllBytes(Paths.get(path, new String[0]));
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(Paths.get(path))");
            byte[] byArray2 = byArray;
            String content = new String(byArray2, Charsets.UTF_8);
        }
        catch (Exception exception) {
            string = "";
        }
        return string;
    }

    public final void initTmp(@NotNull Project project, @NotNull Variant variant) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        File dir = project.getProjectDir();
        String codePath = "build/communication/" + variant.getName();
        File buildFile = new File(dir, codePath);
        buildConfigCacheFile = new File(buildFile.getAbsolutePath(), "tmp.json");
        if (this.temporaryDirMkdirs()) {
            File file = buildConfigCacheFile;
            if (file == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"buildConfigCacheFile");
                file = null;
            }
            String string = file.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buildConfigCacheFile.absolutePath");
            IncrementalRecord bean = this.optFromJsonString(this.readAsString(string), IncrementalRecord.class);
            IncrementalRecordUtils.INSTANCE.init(bean);
        }
    }

    public final void exportTmp() {
        String json = new GsonBuilder().setPrettyPrinting().create().toJson((Object)IncrementalRecordUtils.INSTANCE.getIncrementalRecord());
        File file = buildConfigCacheFile;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"buildConfigCacheFile");
            file = null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)json, (String)"json");
        this.saveFile(file, json);
    }

    private final boolean temporaryDirMkdirs() {
        File file = buildConfigCacheFile;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"buildConfigCacheFile");
            file = null;
        }
        if (!file.getParentFile().exists()) {
            File file2 = buildConfigCacheFile;
            if (file2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"buildConfigCacheFile");
                file2 = null;
            }
            file2.getParentFile().mkdirs();
            return false;
        }
        return true;
    }

    static {
        Gson gson = new GsonBuilder().create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"GsonBuilder().create()");
        TmpUtils.gson = gson;
    }
}

