/*
 * Decompiled with CFR 0.152.
 */
package io.github.acdcjunior.java6fp;

import io.github.acdcjunior.java6fp.FPUtils;
import io.github.acdcjunior.java6fp.fn.FPFunction;
import io.github.acdcjunior.java6fp.fn.FPPredicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FPList<T>
implements Iterable<T> {
    public static final int ARRAYLIST_DEFAULT_CAPACITY = 10;
    @NotNull
    private final List<T> immutableBackingList;

    @NotNull
    public static <T> FPList<T> listOf(@Nullable Iterator<T> iterator) {
        if (iterator == null) {
            return FPList.emptyList();
        }
        return new FPList<T>(FPUtils.toArrayList(iterator));
    }

    @NotNull
    public static <T> FPList<T> listOf(@Nullable Iterable<T> iterable) {
        return FPList.listOf(iterable == null ? null : iterable.iterator());
    }

    @NotNull
    public static <T> FPList<T> listOf(T ... items) {
        if (items == null || items.length == 0) {
            return FPList.emptyList();
        }
        return new FPList<T>(new ArrayList<T>(Arrays.asList(items)));
    }

    private static <T> FPList<T> emptyList() {
        return new FPList(Collections.emptyList());
    }

    private FPList(@NotNull List<T> immutableBackingList) {
        this.immutableBackingList = immutableBackingList;
    }

    public boolean equals(Object o) {
        if (o instanceof FPList) {
            return this.immutableBackingList.equals(((FPList)o).immutableBackingList);
        }
        return this.immutableBackingList.equals(o);
    }

    public int hashCode() {
        return this.immutableBackingList.hashCode();
    }

    public String toString() {
        return this.immutableBackingList.toString();
    }

    @NotNull
    public List<T> toList() {
        return this.immutableBackingList;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return this.immutableBackingList.iterator();
    }

    public int size() {
        return this.immutableBackingList.size();
    }

    @NotNull
    public <R> FPList<R> map(@NotNull FPFunction<? super T, ? extends R> mapper) {
        ArrayList<R> rs = new ArrayList<R>(this.size());
        for (T item : this) {
            rs.add(mapper.apply(item));
        }
        return new FPList(rs);
    }

    @NotNull
    public FPList<T> filter(@NotNull FPPredicate<? super T> predicate) {
        ArrayList<T> rs = new ArrayList<T>(this.size());
        for (T item : this) {
            if (!predicate.test(item)) continue;
            rs.add(item);
        }
        return new FPList(rs);
    }

    @NotNull
    public final FPList<T> concat(Iterable<? extends T> ... iterables) {
        ArrayList<T> ls = new ArrayList<T>(this.immutableBackingList.size() + iterables.length * 10);
        ls.addAll(this.immutableBackingList);
        for (Iterable<T> iterable : iterables) {
            for (T item : iterable) {
                ls.add(item);
            }
        }
        return new FPList(ls);
    }

    @NotNull
    public FPList<T> filterNonNull() {
        return this.filter(new FPPredicate<T>(){

            @Override
            public boolean test(@Nullable T t) {
                return t != null;
            }
        });
    }

    @NotNull
    public FPList<T> distinct() {
        return FPList.listOf(new LinkedHashSet<T>(this.immutableBackingList).iterator());
    }

    @NotNull
    public FPList<T> subtract(@NotNull Iterable<T> other) {
        final List<T> otherLs = FPUtils.toArrayList(other);
        return this.filter(new FPPredicate<T>(){

            @Override
            public boolean test(@Nullable T t) {
                return !otherLs.contains(t);
            }
        });
    }

    @NotNull
    public final FPList<T> subtract(T ... c) {
        return this.subtract(FPList.listOf(c));
    }

    @NotNull
    public final FPList<T> plus(Iterable<? extends T> ... others) {
        return this.concat(others);
    }

    @NotNull
    public final FPList<T> plus(T ... c) {
        return this.plus(new Iterable[]{FPList.listOf(c)});
    }
}

