/*
 * Decompiled with CFR 0.152.
 */
package cpufeatures.x86;

import cpufeatures.headers.x86.CpuInfoX86;
import cpufeatures.x86.X86Feature;
import cpufeatures.x86.X86Features;
import cpufeatures.x86.X86Uarch;
import java.lang.foreign.Addressable;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.MemorySession;
import java.lang.foreign.SegmentAllocator;
import java.lang.invoke.VarHandle;
import java.util.LinkedHashSet;
import java.util.Set;

public record X86Info(X86Features features, int family, int model, int stepping, String vendor, String brandString, X86Uarch uarch) {
    private static final VarHandle a$VH = cpufeatures.headers.x86.X86Features.$LAYOUT().varHandle(MemoryLayout.PathElement.groupElement("a"));
    private static final VarHandle b$VH = cpufeatures.headers.x86.X86Features.$LAYOUT().varHandle(MemoryLayout.PathElement.groupElement("b"));
    private static final VarHandle c$VH = cpufeatures.headers.x86.X86Features.$LAYOUT().varHandle(MemoryLayout.PathElement.groupElement("c"));

    private static boolean get(int bits, int position) {
        return (bits >> position & 1) == 1;
    }

    public static X86Info get() {
        try (MemorySession memory = MemorySession.openConfined();){
            MemorySegment info = CpuInfoX86.GetX86Info((SegmentAllocator)memory);
            MemorySegment features = cpufeatures.headers.x86.X86Info.features$slice((MemorySegment)info);
            int a = a$VH.get(features);
            int b = b$VH.get(features);
            int c = c$VH.get(features);
            boolean fpu = X86Info.get(a, 0);
            boolean tsc = X86Info.get(a, 1);
            boolean cx8 = X86Info.get(a, 2);
            boolean clfsh = X86Info.get(a, 3);
            boolean mmx = X86Info.get(a, 4);
            boolean aes = X86Info.get(a, 5);
            boolean erms = X86Info.get(a, 6);
            boolean f16c = X86Info.get(a, 7);
            boolean fma4 = X86Info.get(a, 8);
            boolean fma3 = X86Info.get(a, 9);
            boolean vaes = X86Info.get(a, 10);
            boolean vpclmulqdq = X86Info.get(a, 11);
            boolean bmi1 = X86Info.get(a, 12);
            boolean hle = X86Info.get(a, 13);
            boolean bmi2 = X86Info.get(a, 14);
            boolean rtm = X86Info.get(a, 15);
            boolean rdseed = X86Info.get(a, 16);
            boolean clflushopt = X86Info.get(a, 17);
            boolean clwb = X86Info.get(a, 18);
            boolean sse = X86Info.get(a, 19);
            boolean sse2 = X86Info.get(a, 20);
            boolean sse3 = X86Info.get(a, 21);
            boolean ssse3 = X86Info.get(a, 22);
            boolean sse4_1 = X86Info.get(a, 23);
            boolean sse4_2 = X86Info.get(a, 24);
            boolean sse4a = X86Info.get(a, 25);
            boolean avx = X86Info.get(a, 26);
            boolean avx_vnni = X86Info.get(a, 27);
            boolean avx2 = X86Info.get(a, 28);
            boolean avx512f = X86Info.get(a, 29);
            boolean avx512cd = X86Info.get(a, 30);
            boolean avx512er = X86Info.get(a, 31);
            boolean avx512pf = X86Info.get(b, 0);
            boolean avx512bw = X86Info.get(b, 1);
            boolean avx512dq = X86Info.get(b, 2);
            boolean avx512vl = X86Info.get(b, 3);
            boolean avx512ifma = X86Info.get(b, 4);
            boolean avx512vbmi = X86Info.get(b, 5);
            boolean avx512vbmi2 = X86Info.get(b, 6);
            boolean avx512vnni = X86Info.get(b, 7);
            boolean avx512bitalg = X86Info.get(b, 8);
            boolean avx512vpopcntdq = X86Info.get(b, 9);
            boolean avx512_4vnniw = X86Info.get(b, 10);
            boolean avx512_4vbmi2 = X86Info.get(b, 11);
            boolean avx512_second_fma = X86Info.get(b, 12);
            boolean avx512_4fmaps = X86Info.get(b, 13);
            boolean avx512_bf16 = X86Info.get(b, 14);
            boolean avx512_vp2intersect = X86Info.get(b, 15);
            boolean avx512_fp16 = X86Info.get(b, 16);
            boolean amx_bf16 = X86Info.get(b, 17);
            boolean amx_tile = X86Info.get(b, 18);
            boolean amx_int8 = X86Info.get(b, 19);
            boolean pclmulqdq = X86Info.get(b, 20);
            boolean smx = X86Info.get(b, 21);
            boolean sgx = X86Info.get(b, 22);
            boolean cx16 = X86Info.get(b, 23);
            boolean sha = X86Info.get(b, 24);
            boolean popcnt = X86Info.get(b, 25);
            boolean movbe = X86Info.get(b, 26);
            boolean rdrnd = X86Info.get(b, 27);
            boolean dca = X86Info.get(b, 28);
            boolean ss = X86Info.get(b, 29);
            boolean adx = X86Info.get(b, 30);
            boolean lzcnt = X86Info.get(b, 31);
            boolean gfni = X86Info.get(c, 0);
            boolean movdiri = X86Info.get(c, 1);
            boolean movdir64b = X86Info.get(c, 2);
            boolean fs_rep_mov = X86Info.get(c, 3);
            boolean fz_rep_movsb = X86Info.get(c, 4);
            boolean fs_rep_stosb = X86Info.get(c, 5);
            boolean fs_rep_cmpsb_scasb = X86Info.get(c, 6);
            int family = cpufeatures.headers.x86.X86Info.family$get((MemorySegment)info);
            int model = cpufeatures.headers.x86.X86Info.model$get((MemorySegment)info);
            int stepping = cpufeatures.headers.x86.X86Info.stepping$get((MemorySegment)info);
            String vendor = cpufeatures.headers.x86.X86Info.vendor$slice((MemorySegment)info).getUtf8String(0L);
            String brandString = cpufeatures.headers.x86.X86Info.brand_string$slice((MemorySegment)info).getUtf8String(0L);
            X86Uarch uarch = X86Uarch.values()[CpuInfoX86.GetX86Microarchitecture((Addressable)info)];
            X86Info x86Info = new X86Info(new X86Features(fpu, tsc, cx8, clfsh, mmx, aes, erms, f16c, fma4, fma3, vaes, vpclmulqdq, bmi1, hle, bmi2, rtm, rdseed, clflushopt, clwb, sse, sse2, sse3, ssse3, sse4_1, sse4_2, sse4a, avx, avx_vnni, avx2, avx512f, avx512cd, avx512er, avx512pf, avx512bw, avx512dq, avx512vl, avx512ifma, avx512vbmi, avx512vbmi2, avx512vnni, avx512bitalg, avx512vpopcntdq, avx512_4vnniw, avx512_4vbmi2, avx512_second_fma, avx512_4fmaps, avx512_bf16, avx512_vp2intersect, avx512_fp16, amx_bf16, amx_tile, amx_int8, pclmulqdq, smx, sgx, cx16, sha, popcnt, movbe, rdrnd, dca, ss, adx, lzcnt, gfni, movdiri, movdir64b, fs_rep_mov, fz_rep_movsb, fs_rep_stosb, fs_rep_cmpsb_scasb), family, model, stepping, vendor, brandString, uarch);
            return x86Info;
        }
    }

    public Set<X86Feature> featureSet() {
        LinkedHashSet<X86Feature> result = new LinkedHashSet<X86Feature>();
        for (X86Feature feature : X86Feature.values()) {
            if (!feature.in(this.features)) continue;
            result.add(feature);
        }
        return result;
    }
}

