/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.json.find;

import java.util.List;
import java.util.Optional;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import sk.antons.json.JsonValue;
import sk.antons.json.match.PathMatcher;
import sk.antons.json.match.SPM;

public class PathFinder {
    JsonValue root;
    PathMatcher matcher;

    public PathFinder(JsonValue root, PathMatcher matcher) {
        this.root = root;
        this.matcher = matcher;
    }

    public static PathFinder of(JsonValue root, PathMatcher matcher) {
        return new PathFinder(root, matcher);
    }

    public static PathFinder of(JsonValue root, String ... path) {
        return new PathFinder(root, SPM.path(path));
    }

    public List<JsonValue> all() {
        return this.root.findAll(this.matcher);
    }

    public Stream<JsonValue> stream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.all().iterator(), 1024), false);
    }

    public JsonValue first() {
        return this.root.findFirst(this.matcher);
    }

    public Optional<JsonValue> optional() {
        return Optional.ofNullable(this.first());
    }

    public List<String> allLiterals() {
        return this.root.findAllLiterals(this.matcher);
    }

    public Stream<String> streamLiterals() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.allLiterals().iterator(), 1024), false);
    }

    public String firstLiteral() {
        return this.root.findFirstLiteral(this.matcher);
    }

    public Optional<String> optionalLiteral() {
        return Optional.ofNullable(this.firstLiteral());
    }
}

