/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.json.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import sk.antons.json.JsonAttribute;
import sk.antons.json.JsonObject;
import sk.antons.json.JsonValue;
import sk.antons.json.impl.JsonArrayImpl;
import sk.antons.json.impl.JsonAttributeImpl;
import sk.antons.json.impl.JsonGroup;
import sk.antons.json.impl.JsonMember;
import sk.antons.json.impl.JsonValueImpl;
import sk.antons.json.literal.impl.JsonStringLiteralImpl;
import sk.antons.json.match.Match;
import sk.antons.json.match.PathMatcher;
import sk.antons.json.template.JsonObjectMapWrapper;

public class JsonObjectImpl
extends JsonValueImpl
implements JsonObject,
JsonGroup,
JsonMember {
    private List<JsonAttributeImpl> attrs = new ArrayList<JsonAttributeImpl>();

    public List<JsonAttributeImpl> attrs() {
        return this.attrs;
    }

    @Override
    protected void toCompactString(Appendable sb) {
        try {
            sb.append('{');
            boolean first = true;
            for (JsonAttributeImpl attr : this.attrs) {
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                sb.append(attr.name().literal());
                sb.append(":");
                ((JsonValueImpl)attr.value()).toCompactString(sb);
            }
            sb.append('}');
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new IllegalStateException(e);
        }
    }

    @Override
    protected void toPrettyString(Appendable sb, String prefix, String indent) {
        try {
            sb.append("{\n");
            boolean first = true;
            for (JsonAttributeImpl attr : this.attrs) {
                if (first) {
                    first = false;
                } else {
                    sb.append(",\n");
                }
                sb.append(prefix).append(indent);
                attr.name().writeCompact(sb);
                sb.append(" : ");
                ((JsonValueImpl)attr.value()).toPrettyString(sb, prefix + indent, indent);
            }
            sb.append("\n");
            sb.append(prefix).append("}");
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new IllegalStateException(e);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.attrs.isEmpty();
    }

    @Override
    public int size() {
        return this.attrs.size();
    }

    @Override
    public void clear() {
        this.attrs.clear();
    }

    @Override
    public JsonAttribute attr(int index) {
        return this.attrs.get(index);
    }

    @Override
    public JsonValue first() {
        if (this.attrs.isEmpty()) {
            return null;
        }
        return this.attrs.get(0).value();
    }

    @Override
    public JsonValue last() {
        if (this.attrs.isEmpty()) {
            return null;
        }
        return this.attrs.get(this.attrs.size() - 1).value();
    }

    @Override
    public JsonAttribute removeAttr(int index) {
        return this.attrs.remove(index);
    }

    @Override
    public List<JsonAttribute> toList() {
        ArrayList<JsonAttribute> list = new ArrayList<JsonAttribute>();
        list.addAll(this.attrs);
        return list;
    }

    private int findIndex(String name) {
        if (this.attrs.isEmpty()) {
            return -1;
        }
        int size = this.attrs.size();
        for (int i = 0; i < size; ++i) {
            JsonAttribute attr = this.attrs.get(i);
            if (!name.equals(attr.name().stringValue())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public JsonObject add(String name, JsonValue value) {
        if (name == null) {
            throw new IllegalArgumentException("JsonAttribute name can't be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("JsonAttribute value can't be null");
        }
        JsonAttributeImpl attr = new JsonAttributeImpl();
        attr.setGroup(this);
        attr.setName(JsonStringLiteralImpl.fromValue(name));
        attr.setValue(value);
        if (value instanceof JsonMember) {
            ((JsonMember)((Object)value)).setGroup(attr);
        }
        this.attrs.add(attr);
        return this;
    }

    @Override
    public JsonObject add(String name, JsonValue value, int index) {
        if (name == null) {
            throw new IllegalArgumentException("JsonAttribute name can't be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("JsonAttribute value can't be null");
        }
        JsonAttributeImpl attr = new JsonAttributeImpl();
        attr.setGroup(this);
        attr.setName(JsonStringLiteralImpl.fromValue(name));
        attr.setValue(value);
        this.attrs.add(index, attr);
        return this;
    }

    @Override
    public int firstIndex(String name) {
        return this.firstIndex(name);
    }

    @Override
    public JsonValue first(String name) {
        if (name == null) {
            return null;
        }
        if (this.attrs.isEmpty()) {
            return null;
        }
        for (JsonAttributeImpl attr : this.attrs) {
            if (!name.equals(attr.name().stringValue())) continue;
            return attr.value();
        }
        return null;
    }

    @Override
    public List<JsonValue> all(String name) {
        ArrayList<JsonValue> list = new ArrayList<JsonValue>();
        if (name == null) {
            return list;
        }
        if (this.attrs.isEmpty()) {
            return list;
        }
        for (JsonAttributeImpl attr : this.attrs) {
            if (!name.equals(attr.name().stringValue())) continue;
            list.add(attr.value());
        }
        return list;
    }

    @Override
    public JsonObject removeAll(String name) {
        if (name == null) {
            return this;
        }
        if (this.attrs.isEmpty()) {
            return this;
        }
        int size = this.attrs.size();
        Iterator<JsonAttributeImpl> iter = this.attrs.iterator();
        while (iter.hasNext()) {
            JsonAttributeImpl attr = iter.next();
            if (!name.equals(attr.name().stringValue())) continue;
            iter.remove();
        }
        return this;
    }

    @Override
    public int memberIndex(JsonMember m) {
        if (m == null) {
            return -1;
        }
        if (!(m instanceof JsonAttribute)) {
            return -1;
        }
        return this.attrs.indexOf(m);
    }

    @Override
    public JsonValue findFirst(PathMatcher matcher, List<String> path) {
        Match result = matcher.match(path, this);
        if (result == Match.NOPE) {
            return null;
        }
        if (result == Match.FULLY) {
            return this;
        }
        boolean index = false;
        for (JsonAttribute jsonAttribute : this.attrs) {
            String name = jsonAttribute.name().stringValue();
            path.add(name);
            JsonValue rv = ((JsonValueImpl)jsonAttribute.value()).findFirst(matcher, path);
            if (rv != null) {
                return rv;
            }
            path.remove(path.size() - 1);
        }
        return null;
    }

    @Override
    public void findAll(PathMatcher matcher, List<JsonValue> values, List<String> path) {
        Match result = matcher.match(path, this);
        if (result == Match.NOPE) {
            return;
        }
        if (result == Match.FULLY) {
            values.add(this);
            return;
        }
        boolean index = false;
        for (JsonAttribute jsonAttribute : this.attrs) {
            String name = jsonAttribute.name().stringValue();
            path.add(name);
            ((JsonValueImpl)jsonAttribute.value()).findAll(matcher, values, path);
            path.remove(path.size() - 1);
        }
    }

    @Override
    public JsonAttribute attr(String name) {
        if (name == null) {
            return null;
        }
        if (this.attrs.isEmpty()) {
            return null;
        }
        for (JsonAttributeImpl attr : this.attrs) {
            if (!name.equals(attr.name().stringValue())) continue;
            return attr;
        }
        return null;
    }

    @Override
    public List<JsonAttribute> attrs(String name) {
        ArrayList<JsonAttribute> list = new ArrayList<JsonAttribute>();
        if (name == null) {
            return list;
        }
        if (this.attrs.isEmpty()) {
            return list;
        }
        for (JsonAttributeImpl attr : this.attrs) {
            if (!name.equals(attr.name().stringValue())) continue;
            list.add(attr);
        }
        return list;
    }

    public void remove(JsonAttribute attr) {
        if (attr == null) {
            return;
        }
        this.attrs.remove(attr);
    }

    @Override
    public void remove() {
        if (this.group == null) {
            return;
        }
        if (this.group instanceof JsonAttributeImpl) {
            ((JsonAttributeImpl)this.group).remove();
        } else if (this.group instanceof JsonArrayImpl) {
            ((JsonArrayImpl)this.group).remove(this);
        }
        this.setGroup(null);
    }

    @Override
    public JsonValue copy() {
        JsonObjectImpl rv = new JsonObjectImpl();
        for (int i = 0; i < this.attrs.size(); ++i) {
            JsonAttribute attr = this.attr(i);
            rv.add(attr.name().stringValue(), attr.value().copy());
        }
        return rv;
    }

    @Override
    public Object asTemplateParam() {
        return JsonObjectMapWrapper.instance(this);
    }
}

