/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.json.literal.impl;

import java.util.List;
import sk.antons.json.JsonValue;
import sk.antons.json.impl.JsonArrayImpl;
import sk.antons.json.impl.JsonAttributeImpl;
import sk.antons.json.impl.JsonValueImpl;
import sk.antons.json.literal.JsonLiteral;
import sk.antons.json.literal.impl.JsonBoolLiteralImpl;
import sk.antons.json.literal.impl.JsonExpLiteralImpl;
import sk.antons.json.literal.impl.JsonFracLiteralImpl;
import sk.antons.json.literal.impl.JsonIntLiteralImpl;
import sk.antons.json.literal.impl.JsonNullLiteralImpl;
import sk.antons.json.literal.impl.JsonStringLiteralImpl;
import sk.antons.json.match.Match;
import sk.antons.json.match.PathMatcher;

public abstract class JsonLiteralImpl
extends JsonValueImpl
implements JsonLiteral {
    protected String literal;
    protected int offset;
    protected int length;
    private boolean cachedValue = false;
    protected String cachedValueString = null;
    private static final char[] NULL = new char[]{'n', 'u', 'l', 'l'};
    private static final char[] TRUE = new char[]{'t', 'r', 'u', 'e'};
    private static final char[] FALSE = new char[]{'f', 'a', 'l', 's', 'e'};

    public abstract Type type();

    protected JsonLiteralImpl(String literal) {
        if (literal == null) {
            literal = "null";
        }
        this.literal = literal;
        this.offset = 0;
        this.length = literal.length();
    }

    protected JsonLiteralImpl(String literal, int offset, int length) {
        if (literal == null) {
            literal = "null";
        }
        this.literal = literal;
        this.offset = offset;
        this.length = length;
    }

    public static JsonLiteralImpl instance(String literal, int offset, int length) {
        return JsonLiteralImpl.parse(literal, offset, length);
    }

    @Override
    public String literal() {
        return this.literal.substring(this.offset, this.offset + this.length);
    }

    @Override
    public String stringValue() {
        if (this.cachedValue) {
            return this.cachedValueString;
        }
        this.cachedValueString = this.literal();
        this.cachedValue = true;
        return this.cachedValueString;
    }

    private static JsonLiteralImpl parse(String literal) {
        if (literal == null) {
            return new JsonNullLiteralImpl();
        }
        return JsonLiteralImpl.parse(literal, 0, literal.length());
    }

    private static boolean equalsTo(String literal, int offset, int length, char[] value) {
        if (length != value.length) {
            return false;
        }
        int pos = offset;
        for (int i = 0; i < length; ++i) {
            if (literal.charAt(pos++) == value[i]) continue;
            return false;
        }
        return true;
    }

    private static JsonLiteralImpl parse(String literal, int offset, int length) {
        JsonLiteralImpl value = null;
        char first = literal.charAt(offset);
        if (first == '\"') {
            if (literal.charAt(offset + length - 1) == '\"') {
                value = new JsonStringLiteralImpl(literal, offset, length);
            } else {
                JsonLiteralImpl.parseEx("seems to be string but is not terminated by '\"'", literal, offset, length);
            }
        } else if (JsonLiteralImpl.equalsTo(literal, offset, length, NULL)) {
            value = new JsonNullLiteralImpl();
        } else if (JsonLiteralImpl.equalsTo(literal, offset, length, TRUE) || JsonLiteralImpl.equalsTo(literal, offset, length, FALSE)) {
            value = new JsonBoolLiteralImpl(literal, offset, length);
        } else if (first == '-' || first == '+' || first >= '0' && first <= '9') {
            int literalLen = offset + length;
            int ePos = -1;
            int dotPos = -1;
            for (int i = offset; i < literalLen; ++i) {
                char c = literal.charAt(i);
                if ('0' <= c && '9' >= c) continue;
                if ('-' == c || '+' == c) {
                    if (i == offset || i == ePos + 1) continue;
                    JsonLiteralImpl.parseEx("seems to be a number, but sign character is on wrong place", literal, offset, length);
                    continue;
                }
                if ('e' == c || 'E' == c) {
                    if (ePos < 0) {
                        ePos = i;
                        continue;
                    }
                    JsonLiteralImpl.parseEx("seems to be a number, but more than one 'e' inside", literal, offset, length);
                    continue;
                }
                if ('.' == c) {
                    if (ePos < 0) {
                        if (dotPos < 0) {
                            dotPos = i;
                            continue;
                        }
                        JsonLiteralImpl.parseEx("seems to be a number, but more than one '.' inside", literal, offset, length);
                        continue;
                    }
                    JsonLiteralImpl.parseEx("seems to be a number, but '.' can't be in exponent", literal, offset, length);
                    continue;
                }
                JsonLiteralImpl.parseEx("seems to be a number, but contains invalid character '" + c + "'", literal, offset, length);
            }
            value = ePos > -1 ? new JsonExpLiteralImpl(literal, offset, length, dotPos, ePos) : (dotPos > -1 ? new JsonFracLiteralImpl(literal, offset, length, dotPos) : new JsonIntLiteralImpl(literal, offset, length));
        } else {
            JsonLiteralImpl.parseEx("unknown literal type", literal, offset, length);
        }
        return value;
    }

    private static void parseEx(String note, String literal, int offset, int length) {
        throw new IllegalArgumentException("JSValue '" + literal.substring(offset, offset + length) + "' " + note);
    }

    @Override
    protected void toCompactString(Appendable sb) {
        try {
            sb.append(this.literal());
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new IllegalStateException(e);
        }
    }

    @Override
    protected void toPrettyString(Appendable sb, String prefix, String indent) {
        try {
            sb.append(this.literal());
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new IllegalStateException(e);
        }
    }

    @Override
    public JsonValue findFirst(PathMatcher matcher, List<String> path) {
        Match result = matcher.match(path, this);
        if (result == Match.FULLY) {
            return this;
        }
        return null;
    }

    @Override
    public void findAll(PathMatcher matcher, List<JsonValue> values, List<String> path) {
        Match result = matcher.match(path, this);
        if (result == Match.FULLY) {
            values.add(this);
        }
    }

    @Override
    public void remove() {
        if (this.group == null) {
            return;
        }
        if (this.group instanceof JsonAttributeImpl) {
            ((JsonAttributeImpl)this.group).remove();
        } else if (this.group instanceof JsonArrayImpl) {
            ((JsonArrayImpl)this.group).remove(this);
        }
        this.setGroup(null);
    }

    public static enum Type {
        NULL,
        BOOL,
        INT,
        FRAC,
        EXP,
        STRING;

    }
}

