/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.json.parse;

import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import sk.antons.json.JsonValue;
import sk.antons.json.impl.JsonArrayImpl;
import sk.antons.json.impl.JsonAttributeImpl;
import sk.antons.json.impl.JsonGroup;
import sk.antons.json.impl.JsonMember;
import sk.antons.json.impl.JsonObjectImpl;
import sk.antons.json.literal.impl.JsonLiteralImpl;
import sk.antons.json.literal.impl.JsonStringLiteralImpl;
import sk.antons.json.parse.traversal.JsonContentHandler;
import sk.antons.json.parse.traversal.TraversalParser;
import sk.antons.json.source.JsonSource;
import sk.antons.json.source.ReaderSource;
import sk.antons.json.source.StringSource;

public class JsonParser {
    public static JsonValue parse(String json) {
        return JsonParser.parse(StringSource.instance(json));
    }

    public static JsonValue parse(Reader json) {
        return JsonParser.parse(ReaderSource.instance(json));
    }

    public static JsonValue parsePrefetched(Reader json) {
        try {
            int numCharsRead;
            if (!(json instanceof BufferedReader)) {
                json = new BufferedReader(json);
            }
            StringBuilder buffer = new StringBuilder();
            char[] arr = new char[2048];
            while ((numCharsRead = json.read(arr, 0, arr.length)) != -1) {
                buffer.append(arr, 0, numCharsRead);
            }
            json.close();
            String targetString = buffer.toString();
            return JsonParser.parse(StringSource.instance(targetString));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static JsonValue parse(JsonSource source) {
        Handler handler = new Handler();
        TraversalParser tparser = TraversalParser.instance(source, handler);
        tparser.parse();
        return handler.getValue();
    }

    private static class Handler
    implements JsonContentHandler {
        private Object current = null;
        private Step lastStep = null;
        private int expected = 0;
        private int deprecated = 0;

        private Handler() {
        }

        public JsonValue getValue() {
            return (JsonValue)this.current;
        }

        private String path() {
            ArrayList<String> items = new ArrayList<String>();
            Object ccurrent = this.current;
            while (ccurrent != null) {
                if (ccurrent instanceof JsonLiteralImpl) {
                    items.add(((JsonLiteralImpl)ccurrent).literal());
                } else if (ccurrent instanceof JsonAttributeImpl) {
                    items.add(((JsonAttributeImpl)ccurrent).name().literal());
                } else if (ccurrent instanceof JsonArrayImpl) {
                    items.add(String.valueOf(((JsonArrayImpl)ccurrent).values().size()));
                }
                if (ccurrent instanceof JsonMember) {
                    ccurrent = ((JsonMember)ccurrent).group();
                    continue;
                }
                ccurrent = null;
            }
            StringBuilder sb = new StringBuilder();
            for (int i = items.size() - 1; i >= 0; --i) {
                if (sb.length() > 0) {
                    sb.append(" / ");
                }
                sb.append((String)items.get(i));
            }
            return sb.toString();
        }

        private static String expectedValues(int expected) {
            StringBuilder sb = new StringBuilder();
            for (Step value : Step.values()) {
                if ((value.bit & expected) == 0) continue;
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append((Object)value);
            }
            return sb.toString();
        }

        private void expects(Step step) {
            if (this.expected != 0 && (this.expected & step.bit) == 0) {
                this.parseEx("Element " + (Object)((Object)step) + " was not espected at this position. Expected one of (" + Handler.expectedValues(this.expected) + ")");
            }
            if (this.deprecated != 0 && (this.deprecated & step.bit) != 0) {
                this.parseEx("Element " + (Object)((Object)step) + " was not depricated at this position");
            }
        }

        private void parseEx(String note) {
            throw new IllegalArgumentException("Unable to parse source because of: " + note);
        }

        @Override
        public void startDocument() {
            this.expects(Step.START_DOCUMENT);
            if (this.current != null) {
                this.parseEx("start document after something parsed");
            }
            this.lastStep = Step.START_DOCUMENT;
            this.expected = Step.LITERAL.bit | Step.START_ARRAY.bit | Step.START_OBJECT.bit | Step.END_DOCUMENT.bit;
        }

        @Override
        public void endDocument() {
            this.expects(Step.END_DOCUMENT);
            this.lastStep = Step.END_DOCUMENT;
            this.expected = Step.START_DOCUMENT.bit;
        }

        @Override
        public void startArray() {
            this.expects(Step.START_ARRAY);
            JsonArrayImpl array = new JsonArrayImpl();
            if (this.current != null && !(this.current instanceof JsonGroup)) {
                this.parseEx("Bad start of JsonArray");
            }
            array.setGroup((JsonGroup)this.current);
            if (this.current != null) {
                if (this.current instanceof JsonAttributeImpl) {
                    JsonAttributeImpl ja = (JsonAttributeImpl)this.current;
                    ja.setValue(array);
                } else if (this.current instanceof JsonArrayImpl) {
                    JsonArrayImpl ja = (JsonArrayImpl)this.current;
                    ja.values().add(array);
                } else {
                    this.parseEx("Bad start of JsonArray");
                }
            }
            this.current = array;
            this.lastStep = Step.START_ARRAY;
            this.expected = Step.LITERAL.bit | Step.START_ARRAY.bit | Step.START_OBJECT.bit | Step.END_DOCUMENT.bit | Step.END_ARRAY.bit;
        }

        @Override
        public void endArray() {
            JsonArrayImpl jo;
            this.expects(Step.END_ARRAY);
            if (this.current == null || !(this.current instanceof JsonArrayImpl)) {
                this.parseEx("Bad end of JsonArray");
            }
            if ((jo = (JsonArrayImpl)this.current).group() == null) {
                this.expected = Step.END_DOCUMENT.bit;
            } else {
                this.current = jo.group();
                if (this.current instanceof JsonAttributeImpl) {
                    this.current = ((JsonAttributeImpl)this.current).group();
                    this.expected = Step.VALUE_SEPARATOR.bit | Step.END_OBJECT.bit;
                } else if (this.current instanceof JsonArrayImpl) {
                    this.expected = Step.VALUE_SEPARATOR.bit | Step.END_ARRAY.bit;
                } else {
                    this.parseEx("End of json object was not expected");
                }
            }
            this.lastStep = Step.END_ARRAY;
        }

        @Override
        public void startObject() {
            this.expects(Step.START_OBJECT);
            if (this.current != null && !(this.current instanceof JsonGroup)) {
                this.parseEx("New json object was not expected here " + this.current);
            }
            JsonObjectImpl jo = new JsonObjectImpl();
            if (this.current != null) {
                if (this.current instanceof JsonAttributeImpl) {
                    JsonAttributeImpl ja = (JsonAttributeImpl)this.current;
                    ja.setValue(jo);
                } else if (this.current instanceof JsonArrayImpl) {
                    JsonArrayImpl ja = (JsonArrayImpl)this.current;
                    ja.values().add(jo);
                } else {
                    this.parseEx("Bad start of JsonObject");
                }
            }
            jo.setGroup((JsonGroup)this.current);
            this.current = jo;
            this.expected = Step.LITERAL.bit | Step.END_OBJECT.bit;
            this.lastStep = Step.START_OBJECT;
        }

        @Override
        public void endObject() {
            JsonObjectImpl jo;
            this.expects(Step.END_OBJECT);
            if (this.current != null && !(this.current instanceof JsonObjectImpl)) {
                this.parseEx("End of json object was not expected");
            }
            if ((jo = (JsonObjectImpl)this.current).group() == null) {
                this.expected = Step.END_DOCUMENT.bit;
            } else {
                this.current = jo.group();
                if (this.current instanceof JsonAttributeImpl) {
                    this.current = ((JsonAttributeImpl)this.current).group();
                    this.expected = Step.VALUE_SEPARATOR.bit | Step.END_OBJECT.bit;
                } else if (this.current instanceof JsonArrayImpl) {
                    this.expected = Step.VALUE_SEPARATOR.bit | Step.END_ARRAY.bit;
                } else {
                    this.parseEx("End of json object was not expected");
                }
            }
            this.lastStep = Step.END_ARRAY;
        }

        @Override
        public void valueSeparator() {
            this.expects(Step.VALUE_SEPARATOR);
            this.lastStep = Step.VALUE_SEPARATOR;
            this.expected = Step.LITERAL.bit | Step.START_ARRAY.bit | Step.START_OBJECT.bit;
        }

        @Override
        public void nameSeparator() {
            this.expects(Step.NAME_SEPARATOR);
            this.lastStep = Step.NAME_SEPARATOR;
            this.expected = Step.LITERAL.bit | Step.START_ARRAY.bit | Step.START_OBJECT.bit;
        }

        @Override
        public void literal(JsonLiteralImpl literal) {
            this.expects(Step.LITERAL);
            if (this.current == null) {
                this.current = literal;
                this.expected = Step.END_DOCUMENT.bit;
            } else if (this.current instanceof JsonArrayImpl) {
                ((JsonArrayImpl)this.current).values().add(literal);
                this.expected = Step.VALUE_SEPARATOR.bit | Step.END_ARRAY.bit;
            } else if (this.current instanceof JsonObjectImpl) {
                JsonObjectImpl jo = (JsonObjectImpl)this.current;
                if (!(literal instanceof JsonStringLiteralImpl)) {
                    this.parseEx("expected string literal but found " + literal.literal());
                }
                JsonAttributeImpl attr = new JsonAttributeImpl();
                attr.setGroup(jo);
                jo.attrs().add(attr);
                attr.setName((JsonStringLiteralImpl)literal);
                this.current = attr;
                this.expected = Step.NAME_SEPARATOR.bit;
            } else if (this.current instanceof JsonAttributeImpl) {
                JsonAttributeImpl attr = (JsonAttributeImpl)this.current;
                attr.setValue(literal);
                this.current = attr.group();
                this.expected = Step.VALUE_SEPARATOR.bit | Step.END_OBJECT.bit;
            } else {
                this.parseEx("Literal " + literal.literal() + " was not expected at this place");
            }
            this.lastStep = Step.LITERAL;
        }

        @Override
        public void whiteSpace(String content, int offset, int length) {
        }

        @Override
        public String contextInfo() {
            return this.path();
        }
    }

    private static enum Step {
        START_DOCUMENT(1),
        END_DOCUMENT(2),
        START_ARRAY(4),
        END_ARRAY(8),
        START_OBJECT(16),
        END_OBJECT(32),
        VALUE_SEPARATOR(64),
        NAME_SEPARATOR(128),
        LITERAL(256),
        WHITE_SPACE(512);

        int bit;

        private Step(int bit) {
            this.bit = bit;
        }
    }
}

