/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.json.parse;

import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import sk.antons.json.JsonValue;
import sk.antons.json.match.Match;
import sk.antons.json.match.PathMatcher;
import sk.antons.json.match.SPM;
import sk.antons.json.parse.JsonScanner;
import sk.antons.json.source.JsonSource;
import sk.antons.json.source.ReaderSource;
import sk.antons.json.source.StringSource;

public class JsonStream {
    private PathMatcher matcher;
    private JsonSource source;

    public JsonStream(JsonSource source, PathMatcher matcher) {
        this.matcher = matcher;
        this.source = source;
    }

    public static JsonStream instance(JsonSource source, PathMatcher matcher) {
        return new JsonStream(source, matcher);
    }

    public static JsonStream instance(String json, PathMatcher matcher) {
        return new JsonStream(new StringSource(json), matcher);
    }

    public static JsonStream instance(Reader reader, PathMatcher matcher) {
        return new JsonStream(new ReaderSource(reader), matcher);
    }

    public Iterator<JsonValue> iterator() {
        return new JsonIterator(JsonScanner.instance(this.source));
    }

    public Stream<JsonValue> stream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(), 1024), false);
    }

    public static void main(String[] argv) throws Exception {
        FileReader reader = new FileReader("/home/antons/Downloads/sample.json");
        JsonStream stream = JsonStream.instance(reader, (PathMatcher)SPM.path("web-app", "servlet", "*", "servlet-name"));
        Iterator<JsonValue> iter = stream.iterator();
        while (iter.hasNext()) {
            JsonValue next = iter.next();
            System.out.println(" ----====----- " + next.toCompactString());
        }
    }

    private class JsonIterator
    implements Iterator<JsonValue> {
        JsonScanner scanner;
        List<String> path = new ArrayList<String>();
        Context context = null;
        boolean finished = false;
        private JsonValue nextone = null;

        public JsonIterator(JsonScanner scanner) {
            this.scanner = scanner;
        }

        private void fixPathAfterItemEnd() {
            if (this.context != null && this.context.array) {
                if (this.path.size() > 0) {
                    this.path.remove(this.path.size() - 1);
                }
                this.path.add(String.valueOf(this.context.arrayCounter++));
            } else if (this.path.size() > 0) {
                this.path.remove(this.path.size() - 1);
            }
        }

        private JsonValue nextPath() {
            JsonScanner.Token token;
            if (this.context != null) {
                Match match;
                this.fixPathAfterItemEnd();
                if (this.context.array && (match = JsonStream.this.matcher.match(this.path, null)) == Match.FULLY) {
                    JsonValue v = this.scanner.readNext();
                    if (v == null) {
                        this.context = this.context.prev;
                        if (this.path.size() > 0) {
                            this.path.remove(this.path.size() - 1);
                        }
                    } else {
                        return v;
                    }
                }
            }
            if ((token = this.scanner.next()) == null) {
                return null;
            }
            while (token != null) {
                Match match;
                if (token == JsonScanner.Token.OBJECT_START) {
                    this.context = Context.object(this.context);
                } else if (token == JsonScanner.Token.ARRAY_START) {
                    this.context = Context.array(this.context);
                    this.path.add(String.valueOf(this.context.arrayCounter++));
                    match = JsonStream.this.matcher.match(this.path, null);
                    if (match == Match.FULLY) {
                        return this.scanner.readNext();
                    }
                } else if (token == JsonScanner.Token.NAME) {
                    this.path.add(this.scanner.stringValue());
                    match = JsonStream.this.matcher.match(this.path, null);
                    if (match == Match.FULLY) {
                        return this.scanner.readNext();
                    }
                } else if (token == JsonScanner.Token.OBJECT_END) {
                    this.context = this.context.prev;
                    this.fixPathAfterItemEnd();
                } else if (token == JsonScanner.Token.ARRAY_END) {
                    this.context = this.context.prev;
                    this.fixPathAfterItemEnd();
                } else {
                    this.fixPathAfterItemEnd();
                }
                token = this.scanner.next();
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            if (this.finished) {
                return false;
            }
            this.nextone = this.nextPath();
            if (this.nextone == null) {
                this.finished = true;
            }
            return this.nextone != null;
        }

        @Override
        public JsonValue next() {
            if (this.finished) {
                return null;
            }
            return this.nextone;
        }
    }

    private static class Context {
        boolean array = false;
        int arrayCounter = 0;
        Context prev;

        private Context() {
        }

        public static Context array(Context prev) {
            Context c = new Context();
            c.array = true;
            c.prev = prev;
            return c;
        }

        public static Context object(Context prev) {
            Context c = new Context();
            c.array = false;
            c.prev = prev;
            return c;
        }
    }
}

