/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.json.source;

import java.io.BufferedReader;
import java.io.Reader;
import sk.antons.json.source.JsonSource;

public class ReaderSource
implements JsonSource {
    private Reader reader = null;
    int current = -2;
    StringBuilder prev = new StringBuilder();
    StringBuilder sb = null;
    int offset = 0;
    private boolean finito = false;

    public ReaderSource(Reader reader) {
        if (reader == null) {
            throw new IllegalArgumentException("Unable to parse null Json reader");
        }
        if (!(reader instanceof BufferedReader)) {
            reader = new BufferedReader(reader);
        }
        this.reader = reader;
    }

    public static ReaderSource instance(Reader reader) {
        return new ReaderSource(reader);
    }

    private int read() {
        try {
            if (this.finito) {
                return -1;
            }
            int i = this.reader.read();
            if (i != -1 && this.sb != null) {
                this.sb.append((char)i);
            }
            this.finito = i == -1;
            return i;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public int current() {
        if (this.current == -2) {
            this.current = this.read();
        }
        return this.current;
    }

    @Override
    public int next() {
        if (this.current == -2) {
            this.current = this.read();
        }
        int rv = this.current;
        this.current = this.read();
        return rv;
    }

    @Override
    public void move() {
        this.next();
    }

    @Override
    public int startRecording() {
        this.sb = this.prev;
        this.sb.setLength(0);
        if (this.current > -1) {
            this.sb.append((char)this.current);
        }
        return 0;
    }

    @Override
    public int stopRecording() {
        int rv = this.sb.length() - 1;
        if (this.current == -1) {
            ++rv;
        }
        this.sb = null;
        return rv;
    }

    @Override
    public String recordedContent() {
        return this.prev.toString();
    }
}

