/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.sbutils.http;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ResponseStatus;

public class JsonExceptionHandler {
    private static Logger log = LoggerFactory.getLogger(JsonExceptionHandler.class);
    private Consumer<Throwable> logger = null;
    private Function<Throwable, HttpStatus> statusResolver = DefaultStatusResolver.instance();
    private Function<Throwable, ObjectNode> processor = null;

    public static JsonExceptionHandler instance() {
        return new JsonExceptionHandler();
    }

    public JsonExceptionHandler logger(Consumer<Throwable> value) {
        this.logger = value;
        return this;
    }

    public JsonExceptionHandler statusResolver(Function<Throwable, HttpStatus> value) {
        this.statusResolver = value;
        return this;
    }

    public JsonExceptionHandler processor(Function<Throwable, ObjectNode> value) {
        this.processor = value;
        return this;
    }

    public ResponseEntity<ObjectNode> process(Throwable ex) {
        HttpStatus status;
        if (this.logger != null) {
            this.logger.accept(ex);
        }
        ExceptionInfo info = new ExceptionInfo();
        this.resolve(ex, info);
        Throwable t = info.markedExc;
        if (t == null) {
            t = info.lastNonJavaExc;
        }
        if (t == null) {
            t = info.lastExc;
        }
        if (t == null) {
            t = ex;
        }
        if ((status = info.status) == null) {
            status = HttpStatus.INTERNAL_SERVER_ERROR;
        }
        if (this.processor == null) {
            this.processor = DefaultExceptionProcessor.instance();
        }
        ObjectNode node = this.processor instanceof DefaultExceptionProcessor ? ((DefaultExceptionProcessor)this.processor).apply(t, info) : this.processor.apply(t);
        return new ResponseEntity((Object)node, status);
    }

    private void resolve(Throwable t, ExceptionInfo ei) {
        String message;
        String clazz;
        if (t == null) {
            return;
        }
        if (ei.lastExc == null) {
            ei.lastExc = t;
        }
        if (ei.lastNonJavaExc == null && !(clazz = t.getClass().getName()).startsWith("java")) {
            ei.lastNonJavaExc = t;
        }
        if ((message = t.getMessage()) == null) {
            ei.allMessages.add(t.getClass().getSimpleName());
        } else {
            ei.allMessages.add(t.getClass().getSimpleName() + ": " + message);
        }
        if (ei.status == null) {
            HttpStatus status = null;
            if (this.statusResolver != null) {
                status = this.statusResolver.apply(t);
            }
            if (status != null) {
                ei.markedExc = t;
                ei.status = status;
            }
        }
        this.resolve(t.getCause(), ei);
    }

    public static class DefaultStatusResolver
    implements Function<Throwable, HttpStatus> {
        private Map<Class, HttpStatus> cache = new HashMap<Class, HttpStatus>();

        public static DefaultStatusResolver instance() {
            return new DefaultStatusResolver();
        }

        public DefaultStatusResolver status(Class exceptionClass, HttpStatus status) {
            if (exceptionClass == null) {
                throw new IllegalArgumentException("no exceptionClass");
            }
            if (status == null) {
                throw new IllegalArgumentException("no status");
            }
            this.cache.put(exceptionClass, status);
            return this;
        }

        @Override
        public HttpStatus apply(Throwable t) {
            if (t == null) {
                return HttpStatus.INTERNAL_SERVER_ERROR;
            }
            return this.resolveStatus(t.getClass());
        }

        private HttpStatus resolveStatus(Class clazz) {
            if (clazz == null) {
                return HttpStatus.INTERNAL_SERVER_ERROR;
            }
            HttpStatus status = this.cache.get(clazz);
            if (status == null) {
                status = DefaultStatusResolver.resolveAnnotation(clazz);
                if (status == null) {
                    status = DefaultStatusResolver.resolveMethod(clazz);
                }
                if (status == null) {
                    status = this.resolveStatus(clazz.getSuperclass());
                }
                if (status == null) {
                    status = HttpStatus.INTERNAL_SERVER_ERROR;
                }
                this.cache.put(clazz, status);
            }
            return status;
        }

        private static HttpStatus resolveAnnotation(Class clazz) {
            ResponseStatus responseStatus = clazz.getAnnotation(ResponseStatus.class);
            return responseStatus == null ? null : (responseStatus.value() == null ? responseStatus.code() : responseStatus.value());
        }

        private static HttpStatus resolveMethod(Class clazz) {
            Method[] methods = clazz.getDeclaredMethods();
            if (methods == null) {
                return null;
            }
            for (Method method : methods) {
                if (!Modifier.isPublic(method.getModifiers()) || !Modifier.isStatic(method.getModifiers()) || method.getParameterCount() != 0 || !"httpCode".equals(method.getName()) || !Integer.TYPE.equals(method.getReturnType())) continue;
                try {
                    int value = (Integer)method.invoke(null, new Object[0]);
                    if (value > 0) {
                        return HttpStatus.valueOf((int)value);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
            return null;
        }
    }

    private static class ExceptionInfo {
        Throwable lastExc;
        Throwable lastNonJavaExc;
        Throwable markedExc;
        List<String> allMessages = new ArrayList<String>();
        HttpStatus status;

        private ExceptionInfo() {
        }
    }

    public static class DefaultExceptionProcessor
    implements Function<Throwable, ObjectNode> {
        private ObjectMapper om = null;

        public static DefaultExceptionProcessor instance() {
            return new DefaultExceptionProcessor();
        }

        @Override
        public ObjectNode apply(Throwable t) {
            ObjectNode node = null;
            try {
                node = (ObjectNode)this.om().valueToTree((Object)t);
            }
            catch (Exception e) {
                node = new ObjectNode(JsonNodeFactory.instance);
                ArrayNode arr = this.om().createArrayNode();
                for (Throwable tt = t; tt != null; tt = tt.getCause()) {
                    arr.add(tt.getClass().getSimpleName() + ": " + tt.getMessage());
                }
                node.put("serializationError", e.getMessage());
                node.put("causedBy", (JsonNode)arr);
            }
            node.put("class", t.getClass().getSimpleName());
            return node;
        }

        private ObjectNode apply(Throwable t, ExceptionInfo info) {
            ObjectNode node = null;
            try {
                node = (ObjectNode)this.om().valueToTree((Object)t);
            }
            catch (Exception e) {
                node = new ObjectNode(JsonNodeFactory.instance);
                ArrayNode arr = this.om().createArrayNode();
                for (Throwable tt = t; tt != null; tt = tt.getCause()) {
                    arr.add(tt.getClass().getSimpleName() + ": " + tt.getMessage());
                }
                node.put("causedBy", (JsonNode)arr);
                node.put("serializationError", e.getMessage());
            }
            node.put("class", t.getClass().getSimpleName());
            if (info.allMessages.size() > 1) {
                ArrayNode arr = this.om().createArrayNode();
                for (String message : info.allMessages) {
                    arr.add(message);
                }
                node.put("allMesages", (JsonNode)arr);
            }
            return node;
        }

        private ObjectMapper om() {
            if (this.om == null) {
                ObjectMapper o = new ObjectMapper();
                o.setSerializationInclusion(JsonInclude.Include.NON_NULL);
                o.configure(SerializationFeature.INDENT_OUTPUT, true);
                o.addMixIn(Throwable.class, MixIn.class);
                this.om = o;
            }
            return this.om;
        }

        private static abstract class MixIn {
            private MixIn() {
            }

            @JsonIgnore
            abstract Throwable getCause();

            @JsonIgnore
            abstract Throwable[] getSuppressed();

            @JsonIgnore
            abstract StackTraceElement[] getStackTrace();

            @JsonIgnore
            abstract String getLocalizedMessage();
        }
    }
}

