/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.sbutils.http;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.RestTemplate;
import sk.antons.sbutils.util.JsonStreamToString;
import sk.antons.sbutils.util.XmlStreamToString;

public class LoggingInterceptor
implements ClientHttpRequestInterceptor {
    private Consumer<String> logger = null;
    private BooleanSupplier loggerEnabled = null;
    private Function<HttpHeaders, String> requestHeaders = null;
    private Function<HttpHeaders, String> responseHeaders = null;
    private Function<InputStream, String> requestBody = null;
    private Function<InputStream, String> responseBody = null;
    private static int counter = 1;

    private LoggingInterceptor() {
    }

    public static LoggingInterceptor instance() {
        return new LoggingInterceptor();
    }

    public LoggingInterceptor requestHeaders(Function<HttpHeaders, String> value) {
        this.requestHeaders = value;
        return this;
    }

    public LoggingInterceptor responseHeaders(Function<HttpHeaders, String> value) {
        this.responseHeaders = value;
        return this;
    }

    public LoggingInterceptor requestBody(Function<InputStream, String> value) {
        this.requestBody = value;
        return this;
    }

    public LoggingInterceptor responseBody(Function<InputStream, String> value) {
        this.responseBody = value;
        return this;
    }

    public LoggingInterceptor logger(Consumer<String> value) {
        this.logger = value;
        return this;
    }

    public LoggingInterceptor loggerEnabled(BooleanSupplier value) {
        this.loggerEnabled = value;
        return this;
    }

    public void addToTemplate(RestTemplate template) {
        ArrayList<LoggingInterceptor> interceptors = template.getInterceptors();
        if (interceptors == null) {
            interceptors = new ArrayList<LoggingInterceptor>();
        }
        boolean alreadyin = false;
        for (ClientHttpRequestInterceptor clientHttpRequestInterceptor : interceptors) {
            if (!clientHttpRequestInterceptor.equals(this)) continue;
            alreadyin = true;
            break;
        }
        if (!alreadyin) {
            interceptors.add(this);
        }
        template.setInterceptors(interceptors);
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        int reqnum = counter++;
        if (this.loggerEnabled != null && this.loggerEnabled.getAsBoolean() && this.logger != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("http-req[").append(reqnum).append("] ").append(request.getMethodValue()).append(" ").append(request.getURI());
            if (this.requestHeaders != null) {
                sb.append(" headers[").append(this.requestHeaders.apply(request.getHeaders())).append(']');
            }
            if (this.requestBody != null) {
                sb.append(" body[").append(this.requestBody.apply(new ByteArrayInputStream(body))).append("]");
            }
            this.logger.accept(sb.toString());
        }
        long starttime = System.currentTimeMillis();
        ClientHttpResponse response = execution.execute(request, body);
        long endtime = System.currentTimeMillis();
        if (this.loggerEnabled != null && this.loggerEnabled.getAsBoolean() && this.logger != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("http-res[").append(reqnum).append("] ").append(request.getMethodValue()).append(" ").append(request.getURI()).append(" status:").append(response.getRawStatusCode()).append(" time:").append(endtime - starttime);
            if (this.responseHeaders != null) {
                sb.append(" headers[").append(this.responseHeaders.apply(response.getHeaders())).append(']');
            }
            if (this.responseBody != null) {
                response = DuplicatedClientHttpResponse.instance(response, response.getBody());
                sb.append(" body[").append(this.responseBody.apply(response.getBody())).append("]");
            }
            this.logger.accept(sb.toString());
        }
        return response;
    }

    private static class DuplicatedClientHttpResponse
    implements ClientHttpResponse {
        private ClientHttpResponse delegate;
        private byte[] body;

        private DuplicatedClientHttpResponse() {
        }

        public static DuplicatedClientHttpResponse instance(ClientHttpResponse delegate, InputStream body) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                body.transferTo(baos);
                DuplicatedClientHttpResponse rv = new DuplicatedClientHttpResponse();
                rv.delegate = delegate;
                rv.body = baos.toByteArray();
                return rv;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }

        public HttpStatusCode getStatusCode() throws IOException {
            return this.delegate.getStatusCode();
        }

        public int getRawStatusCode() throws IOException {
            return this.delegate.getRawStatusCode();
        }

        public String getStatusText() throws IOException {
            return this.delegate.getStatusText();
        }

        public void close() {
            this.delegate.close();
        }

        public HttpHeaders getHeaders() {
            return this.delegate.getHeaders();
        }

        public InputStream getBody() throws IOException {
            return new ByteArrayInputStream(this.body);
        }
    }

    public static class Body {
        public static XmlStreamToString xml() {
            return XmlStreamToString.instance();
        }

        public static JsonStreamToString json() {
            return JsonStreamToString.instance();
        }
    }

    public static class Headers {
        public static Function<HttpHeaders, String> all() {
            return headers -> {
                StringBuffer sb = new StringBuffer();
                sb.append("headers[");
                if (headers != null) {
                    boolean first = true;
                    for (Map.Entry entry : headers.entrySet()) {
                        String key = (String)entry.getKey();
                        for (String string : (List)entry.getValue()) {
                            if (first) {
                                first = false;
                            } else {
                                sb.append(", ");
                            }
                            sb.append(key).append(": ").append(string);
                        }
                    }
                }
                sb.append("]");
                return sb.toString();
            };
        }

        public static Function<HttpHeaders, String> listed(String ... name) {
            return headers -> {
                StringBuffer sb = new StringBuffer();
                sb.append("headers[");
                if (headers != null && name != null) {
                    boolean first = true;
                    for (Map.Entry entry : headers.entrySet()) {
                        String key = (String)entry.getKey();
                        boolean match = false;
                        for (String string : name) {
                            if (!key.equalsIgnoreCase(string)) continue;
                            match = true;
                            break;
                        }
                        if (!match) continue;
                        for (String string : (List)entry.getValue()) {
                            if (first) {
                                first = false;
                            } else {
                                sb.append(", ");
                            }
                            sb.append(key).append(": ").append(string);
                        }
                    }
                }
                sb.append("]");
                return sb.toString();
            };
        }
    }
}

