/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.sbutils.ws;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.interceptor.Fault;
import sk.antons.sbutils.util.XmlStreamToString;

public class CxfLogInterceptor
extends AbstractSoapInterceptor {
    private static final String LOG_SETUP = CxfLogInterceptor.class.getName() + ".log-setup";
    private Consumer<String> logger = null;
    private BooleanSupplier loggerEnabled = null;
    private Function<InputStream, String> format;
    private boolean out = false;
    private static int counter = 0;
    private static ThreadLocal<Integer> counterCache = new ThreadLocal();
    private static ThreadLocal<SnifferOutputStream> outstreamCache = new ThreadLocal();

    public CxfLogInterceptor(boolean out) {
        super(out ? "pre-stream" : "receive");
        this.out = out;
    }

    public static CxfLogInterceptor out() {
        return new CxfLogInterceptor(true);
    }

    public static CxfLogInterceptor in() {
        return new CxfLogInterceptor(false);
    }

    public static CxfLogInterceptor instance(boolean out) {
        return new CxfLogInterceptor(out);
    }

    public CxfLogInterceptor logger(Consumer<String> value) {
        this.logger = value;
        return this;
    }

    public CxfLogInterceptor loggerEnabled(BooleanSupplier value) {
        this.loggerEnabled = value;
        return this;
    }

    public CxfLogInterceptor format(Function<InputStream, String> value) {
        this.format = value;
        return this;
    }

    private int counter() {
        if (counterCache.get() == null) {
            return 0;
        }
        return counterCache.get();
    }

    private int counterNext() {
        int c = ++counter;
        counterCache.set(c);
        return c;
    }

    private void printOutStream() {
        if (outstreamCache.get() == null) {
            return;
        }
        outstreamCache.get().print();
    }

    private void registerOutStream(SnifferOutputStream stream) {
        outstreamCache.set(stream);
    }

    public void handleMessage(SoapMessage message) throws Fault {
        try {
            boolean logged = message.containsKey((Object)LOG_SETUP);
            if (!logged) {
                message.put(LOG_SETUP, (Object)Boolean.TRUE);
                if (this.out) {
                    OutputStream os = (OutputStream)message.getContent(OutputStream.class);
                    if (os != null) {
                        SnifferOutputStream stream = SnifferOutputStream.instance(os, this.counterNext(), this.format, this.logger, this.loggerEnabled);
                        this.registerOutStream(stream);
                        message.setContent(OutputStream.class, (Object)stream);
                    } else if (this.loggerEnabled != null && this.loggerEnabled.getAsBoolean() && this.logger != null) {
                        this.logger.accept("soap-out[" + this.counterNext() + "]: no data to log");
                    }
                } else {
                    this.printOutStream();
                    InputStream is = (InputStream)message.getContent(InputStream.class);
                    if (is != null) {
                        ByteArrayOutputStream bout = new ByteArrayOutputStream();
                        is.transferTo(bout);
                        String xml = bout.toString();
                        message.setContent(InputStream.class, (Object)new ByteArrayInputStream(bout.toByteArray()));
                        if (this.format != null) {
                            xml = this.format.apply(new ByteArrayInputStream(bout.toByteArray()));
                        }
                        if (this.loggerEnabled != null && this.loggerEnabled.getAsBoolean() && this.logger != null) {
                            this.logger.accept(" soap-in[" + this.counter() + "]: " + xml);
                        }
                    } else if (this.loggerEnabled != null && this.loggerEnabled.getAsBoolean() && this.logger != null) {
                        this.logger.accept(" soap-in[" + this.counter() + "]: no data to log");
                    }
                }
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static class SnifferOutputStream
    extends OutputStream {
        OutputStream os;
        int counter;
        Function<InputStream, String> format;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Consumer<String> logger = null;
        BooleanSupplier loggerEnabled = null;
        private boolean notprinted = true;

        public SnifferOutputStream(OutputStream os, int counter, Function<InputStream, String> format, Consumer<String> logger, BooleanSupplier loggerEnabled) {
            this.os = os;
            this.counter = counter;
            this.format = format;
            this.logger = logger;
            this.loggerEnabled = loggerEnabled;
        }

        public static SnifferOutputStream instance(OutputStream os, int counter, Function<InputStream, String> format, Consumer<String> logger, BooleanSupplier loggerEnabled) {
            return new SnifferOutputStream(os, counter, format, logger, loggerEnabled);
        }

        @Override
        public void close() throws IOException {
            this.os.close();
            this.print();
        }

        @Override
        public void flush() throws IOException {
            this.os.flush();
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.os.write(b, off, len);
            this.baos.write(b, off, len);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.os.write(b);
            this.baos.write(b);
        }

        @Override
        public void write(int i) throws IOException {
            this.os.write(i);
            this.baos.write(i);
        }

        public void print() {
            if (this.loggerEnabled != null && this.loggerEnabled.getAsBoolean() && this.logger != null && this.notprinted) {
                this.notprinted = false;
                String xml = this.baos.toString();
                if (this.format != null) {
                    xml = this.format.apply(new ByteArrayInputStream(this.baos.toByteArray()));
                }
                this.logger.accept("soap-out[" + this.counter + "]: " + xml);
            }
        }
    }

    public static class Format {
        public static XmlStreamToString xml() {
            return XmlStreamToString.instance();
        }
    }
}

