/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.sbutils.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.springframework.boot.env.ConfigTreePropertySource;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public class EnvPrinter {
    private Environment env;
    private Predicate<String> secureSourcePredicate = n -> n.contains("/secrets");
    private Predicate<String> securePropertyPredicate = n -> n.endsWith(".password") || n.endsWith(".key");
    private List<String> propertyNames = new ArrayList<String>();
    private Set<String> securedPropertyNames = new HashSet<String>();

    public EnvPrinter(Environment env) {
        this.env = env;
        this.init();
    }

    public static EnvPrinter instamce(Environment env) {
        return new EnvPrinter(env);
    }

    public Predicate<String> secureSourcePredicate() {
        return this.secureSourcePredicate;
    }

    public EnvPrinter secureSourcePredicate(Predicate<String> value) {
        this.secureSourcePredicate = value;
        return this;
    }

    public Predicate<String> securePropertyPredicate() {
        return this.securePropertyPredicate;
    }

    public EnvPrinter securePropertyPredicate(Predicate<String> value) {
        this.securePropertyPredicate = value;
        return this;
    }

    private void init() {
        if (this.env instanceof AbstractEnvironment) {
            for (PropertySource propertySource : ((AbstractEnvironment)this.env).getPropertySources()) {
                String[] list;
                String sourceName = propertySource.getName();
                if ("systemProperties".equals(sourceName) || "systemEnvironment".equals(sourceName)) continue;
                if (propertySource instanceof MapPropertySource) {
                    Map map = (Map)((MapPropertySource)propertySource).getSource();
                    if (map == null) continue;
                    for (String key : map.keySet()) {
                        if (!this.propertyNames.contains(key)) {
                            this.propertyNames.add(key);
                        }
                        if (this.secureSourcePredicate != null && this.secureSourcePredicate.test(sourceName)) {
                            this.securedPropertyNames.add(key);
                            continue;
                        }
                        if (this.securePropertyPredicate == null || !this.securePropertyPredicate.test(key)) continue;
                        this.securedPropertyNames.add(key);
                    }
                    continue;
                }
                if (!(propertySource instanceof ConfigTreePropertySource) || (list = ((ConfigTreePropertySource)propertySource).getPropertyNames()) == null) continue;
                for (String key : list) {
                    if (!this.propertyNames.contains(key)) {
                        this.propertyNames.add(key);
                    }
                    if (this.secureSourcePredicate != null && this.secureSourcePredicate.test(sourceName)) {
                        this.securedPropertyNames.add(key);
                        continue;
                    }
                    if (this.securePropertyPredicate == null || !this.securePropertyPredicate.test(key)) continue;
                    this.securedPropertyNames.add(key);
                }
            }
        }
        Collections.sort(this.propertyNames);
    }

    public String printBySources() {
        StringBuilder sb = new StringBuilder(300);
        if (this.env instanceof AbstractEnvironment) {
            for (PropertySource propertySource : ((AbstractEnvironment)this.env).getPropertySources()) {
                Object value;
                Map map;
                String sourceName = propertySource.getName();
                if ("systemProperties".equals(sourceName) || "systemEnvironment".equals(sourceName)) {
                    sb.append("\n-- source: ").append(propertySource.getName()).append(" --");
                    map = (Map)((MapPropertySource)propertySource).getSource();
                    if (map == null) continue;
                    for (String key : this.propertyNames) {
                        Object v = map.get(key);
                        if (v == null) continue;
                        value = String.valueOf(v);
                        if (this.securedPropertyNames.contains(key)) {
                            value = ((String)value).replaceAll(".", "*");
                        }
                        sb.append('\n').append(key).append(": ").append((String)value);
                    }
                    continue;
                }
                if (propertySource instanceof MapPropertySource) {
                    sb.append("\n-- source: ").append(propertySource.getName()).append(" --");
                    map = (Map)((MapPropertySource)propertySource).getSource();
                    if (map == null) continue;
                    ArrayList list = new ArrayList(map.keySet());
                    Collections.sort(list);
                    for (String key : list) {
                        value = String.valueOf(map.get(key));
                        if (value == null) {
                            value = "";
                        }
                        if (this.securedPropertyNames.contains(key)) {
                            value = ((String)value).replaceAll(".", "*");
                        }
                        sb.append('\n').append(key).append(": ").append((String)value);
                    }
                    continue;
                }
                if (!(propertySource instanceof ConfigTreePropertySource)) continue;
                sb.append("\n-- source: ").append(propertySource.getName()).append(" --");
                Object[] list = ((ConfigTreePropertySource)propertySource).getPropertyNames();
                if (list == null) continue;
                Arrays.sort(list);
                for (Object key : list) {
                    String value2 = propertySource.getProperty((String)key).toString();
                    if (value2 == null) {
                        value2 = "";
                    }
                    if (this.securedPropertyNames.contains(key)) {
                        value2 = value2.replaceAll(".", "*");
                    }
                    sb.append('\n').append((String)key).append(": ").append(value2);
                }
            }
        }
        return sb.toString();
    }

    public String print() {
        StringBuilder sb = new StringBuilder(300);
        for (String key : this.propertyNames) {
            String value = this.env.getProperty(key);
            if (value == null) continue;
            if (this.securedPropertyNames.contains(key)) {
                value = value.replaceAll(".", "*");
            }
            sb.append('\n').append(key).append(": ").append(value);
        }
        return sb.toString();
    }
}

