/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.sbutils.util;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.function.Function;
import java.util.stream.Collectors;
import sk.antons.loghelpers.format.XmlFormat;

public class XmlStreamToString {
    String encoding = "utf-8";
    boolean formated;
    boolean forceOneLine;
    String indent;
    int cufStringLiteralsLength;
    int expectedLength = 4096;

    public static XmlStreamToString instance() {
        return new XmlStreamToString();
    }

    public XmlStreamToString encoding(String value) {
        this.encoding = value;
        return this;
    }

    public XmlStreamToString forceOneLine() {
        this.forceOneLine = true;
        this.formated = true;
        return this;
    }

    public XmlStreamToString indent(String value) {
        this.indent = value;
        this.formated = true;
        return this;
    }

    public XmlStreamToString cufStringLiterals(int value) {
        this.cufStringLiteralsLength = value;
        this.formated = true;
        return this;
    }

    public XmlStreamToString expectedLength(int value) {
        this.expectedLength = value;
        this.formated = true;
        return this;
    }

    public Function<InputStream, String> transform() {
        if (this.formated) {
            return this.formatted();
        }
        return this.asIs();
    }

    private Function<InputStream, String> asIs() {
        return is -> XmlStreamToString.readStream(is, this.encoding, this.expectedLength);
    }

    private Function<InputStream, String> formatted() {
        return is -> {
            String xml = XmlStreamToString.readStream(is, this.encoding, this.expectedLength);
            XmlFormat format = XmlFormat.instance((String)xml, (int)0);
            if (this.cufStringLiteralsLength > 0) {
                format.cutStringLiterals(this.cufStringLiteralsLength);
            }
            if (this.indent != null) {
                format.indent(this.indent);
            } else if (this.forceOneLine) {
                format.forceoneline();
            }
            return format.format();
        };
    }

    private static String readStream(InputStream is, String encoding, int expectedLength) {
        if (is == null) {
            return null;
        }
        try {
            InputStreamReader isr = new InputStreamReader(is, encoding);
            String s = new BufferedReader(isr, expectedLength).lines().collect(Collectors.joining("\n"));
            return s;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

