/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.siutils.core;

import java.time.Duration;
import java.time.LocalDateTime;
import org.springframework.integration.IntegrationPatternType;
import org.springframework.integration.core.MessageSource;
import org.springframework.messaging.Message;

public class InactivityDelayMessageSource<T>
implements MessageSource<T> {
    private MessageSource<T> delegate;
    private Duration delay;
    private LocalDateTime delayedTo;

    public InactivityDelayMessageSource(MessageSource<T> delegate) {
        this.delegate = delegate;
    }

    public InactivityDelayMessageSource inactivityDelay(Duration delay) {
        this.delay = delay;
        return this;
    }

    public static <P> InactivityDelayMessageSource<P> of(MessageSource<P> delegate) {
        return new InactivityDelayMessageSource<P>(delegate);
    }

    public Message<T> receive() {
        Message message;
        if (this.delayedTo != null) {
            if (this.delayedTo.isAfter(LocalDateTime.now())) {
                return null;
            }
            this.delayedTo = null;
        }
        if ((message = this.delegate.receive()) == null) {
            this.delayedTo = LocalDateTime.now().plus(this.delay);
        }
        return message;
    }

    public IntegrationPatternType getIntegrationPatternType() {
        return this.delegate.getIntegrationPatternType();
    }
}

