/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.siutils.core;

import org.springframework.integration.IntegrationPatternType;
import org.springframework.integration.core.MessageSource;
import org.springframework.messaging.Message;

public class MessageSourceBatchAction<T> {
    private MessageSource<T> delegate;
    private Runnable action;
    private boolean async = false;
    boolean lastNull = true;

    public MessageSourceBatchAction(MessageSource<T> delegate) {
        this.delegate = delegate;
    }

    public static <P> MessageSourceBatchAction<P> of(MessageSource<P> delegate) {
        return new MessageSourceBatchAction<P>(delegate);
    }

    public MessageSourceBatchAction action(Runnable action) {
        this.action = action;
        return this;
    }

    public MessageSourceBatchAction async(boolean async) {
        this.async = async;
        return this;
    }

    public MessageSource<T> before() {
        return BeforeBatchActionMessageSource.of(this.delegate).action(this.action).async(this.async);
    }

    public MessageSource<T> after() {
        return AfterBatchActionMessageSource.of(this.delegate).action(this.action).async(this.async);
    }

    private static class BeforeBatchActionMessageSource<T>
    implements MessageSource<T> {
        private MessageSource<T> delegate;
        private Runnable action;
        private boolean async = false;
        boolean lastNull = true;

        public BeforeBatchActionMessageSource(MessageSource<T> delegate) {
            this.delegate = delegate;
        }

        public BeforeBatchActionMessageSource action(Runnable action) {
            this.action = action;
            return this;
        }

        public BeforeBatchActionMessageSource async(boolean async) {
            this.async = async;
            return this;
        }

        public static <P> BeforeBatchActionMessageSource<P> of(MessageSource<P> delegate) {
            return new BeforeBatchActionMessageSource<P>(delegate);
        }

        public Message<T> receive() {
            Message message = this.delegate.receive();
            if (this.action != null && message != null && this.lastNull) {
                if (this.async) {
                    try {
                        Thread t = new Thread(this.action);
                        t.start();
                    }
                    catch (Throwable throwable) {}
                } else {
                    try {
                        this.action.run();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            this.lastNull = message == null;
            return message;
        }

        public IntegrationPatternType getIntegrationPatternType() {
            return this.delegate.getIntegrationPatternType();
        }
    }

    private static class AfterBatchActionMessageSource<T>
    implements MessageSource<T> {
        private MessageSource<T> delegate;
        private Runnable action;
        private boolean async = false;
        boolean lastNull = true;

        public AfterBatchActionMessageSource(MessageSource<T> delegate) {
            this.delegate = delegate;
        }

        public AfterBatchActionMessageSource action(Runnable action) {
            this.action = action;
            return this;
        }

        public AfterBatchActionMessageSource async(boolean async) {
            this.async = async;
            return this;
        }

        public static <P> AfterBatchActionMessageSource<P> of(MessageSource<P> delegate) {
            return new AfterBatchActionMessageSource<P>(delegate);
        }

        public Message<T> receive() {
            Message message = this.delegate.receive();
            if (this.action != null && message == null && !this.lastNull) {
                if (this.async) {
                    try {
                        Thread t = new Thread(this.action);
                        t.start();
                    }
                    catch (Throwable throwable) {}
                } else {
                    try {
                        this.action.run();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            this.lastNull = message == null;
            return message;
        }

        public IntegrationPatternType getIntegrationPatternType() {
            return this.delegate.getIntegrationPatternType();
        }
    }
}

