/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.siutils.file;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.support.DefaultMessageBuilderFactory;
import org.springframework.integration.support.MessageBuilderFactory;
import org.springframework.messaging.Message;

public class FileByFileMessageSource
implements MessageSource<File> {
    public static final String FILE = "FileByFileMessageSource.FILE";
    private File inputDirectory;
    private File backupDirectory;
    private Comparator<File> comparator = FileNameComparator.instance();
    private File currentFile = null;
    private boolean processing = false;
    private LocalDateTime processingFrom = null;
    private boolean locked = false;
    private MessageBuilderFactory messageBuilderFactory = null;

    public FileByFileMessageSource(String directory) {
        this.inputDirectory = FileByFileMessageSource.createDirectory(directory);
    }

    public static FileByFileMessageSource of(String directory) {
        return new FileByFileMessageSource(directory);
    }

    public FileByFileMessageSource backupDirectory(String directory) {
        this.backupDirectory = FileByFileMessageSource.createDirectory(directory);
        return this;
    }

    public FileByFileMessageSource comparator(Comparator<File> value) {
        this.comparator = value;
        return this;
    }

    public boolean isProcessing() {
        return this.processing;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean value) {
        this.locked = value;
    }

    public Message<File> receive() {
        File f = this.nextFile();
        if (f == null) {
            return null;
        }
        return this.getMessageBuilderFactory().withPayload((Object)f).copyHeaders(Map.of(FILE, f)).setCorrelationId((Object)f.getName()).build();
    }

    public void delete() {
        try {
            if (this.currentFile != null && this.currentFile.exists()) {
                this.currentFile.delete();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        finally {
            this.cleanFile();
        }
    }

    public void move() {
        if (this.backupDirectory == null) {
            throw new IllegalStateException("unable to move file, backupDirectory is null");
        }
        try {
            if (this.currentFile != null && this.currentFile.exists()) {
                File destination = new File(this.backupDirectory.getAbsolutePath() + "/" + this.currentFile.getName());
                Files.move(this.currentFile.toPath(), destination.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        finally {
            this.cleanFile();
        }
    }

    public void reset() {
        this.cleanFile();
    }

    public void lock() {
        this.locked = true;
    }

    public void unlock() {
        this.locked = false;
    }

    public State state() {
        State state = new State();
        File file = this.currentFile;
        state.currentFile = file == null ? null : file.getName();
        state.locked = this.locked;
        state.processing = this.processing;
        state.processingFrom = this.processingFrom;
        try {
            File[] ff = this.inputDirectory.listFiles();
            if (ff != null) {
                Arrays.sort(ff, this.comparator);
                state.preparedFiles = new ArrayList<String>();
                for (File file1 : ff) {
                    state.preparedFiles.add(file1.getName());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return state;
    }

    private synchronized File nextFile() {
        if (this.processing) {
            return null;
        }
        if (this.locked) {
            return null;
        }
        File[] children = this.inputDirectory.listFiles();
        if (children == null) {
            return null;
        }
        if (children.length == 0) {
            return null;
        }
        Arrays.sort(children, this.comparator);
        this.processing = true;
        this.processingFrom = LocalDateTime.now();
        this.currentFile = children[0];
        return this.currentFile;
    }

    protected synchronized MessageBuilderFactory getMessageBuilderFactory() {
        if (this.messageBuilderFactory == null) {
            this.messageBuilderFactory = new DefaultMessageBuilderFactory();
        }
        return this.messageBuilderFactory;
    }

    private void cleanFile() {
        this.currentFile = null;
        this.processingFrom = null;
        this.processing = false;
    }

    private static File createDirectory(String directory) {
        if (directory == null) {
            throw new NullPointerException("unablde to create directory - null");
        }
        File f = new File(directory);
        if (f.exists()) {
            if (!f.isDirectory()) {
                throw new IllegalStateException("not a directory " + directory);
            }
        } else {
            boolean created = f.mkdirs();
            if (!created) {
                throw new IllegalStateException("unable to create directory " + directory);
            }
        }
        return f;
    }

    public static class FileNameComparator
    implements Comparator<File> {
        @Override
        public int compare(File f1, File f2) {
            String n2;
            String n1;
            String string = n1 = f1 == null ? "" : f1.getName();
            if (n1 == null) {
                n1 = "";
            }
            String string2 = n2 = f2 == null ? "" : f2.getName();
            if (n2 == null) {
                n2 = "";
            }
            return n1.compareTo(n2);
        }

        public static FileNameComparator instance() {
            return new FileNameComparator();
        }
    }

    public static class State {
        boolean locked;
        boolean processing;
        LocalDateTime processingFrom;
        String currentFile;
        List<String> preparedFiles;

        public boolean isLocked() {
            return this.locked;
        }

        public boolean isProcessing() {
            return this.processing;
        }

        public LocalDateTime getProcessingFrom() {
            return this.processingFrom;
        }

        public String getCurrentFile() {
            return this.currentFile;
        }

        public List<String> getPreparedFiles() {
            return this.preparedFiles;
        }
    }
}

