/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.siutils.file;

import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import org.springframework.integration.file.DefaultDirectoryScanner;

public class SortedDirectoryScanner
extends DefaultDirectoryScanner {
    private Comparator<File> comparator = NameComparator.instance();

    public SortedDirectoryScanner comparator(Comparator<File> comparator) {
        this.comparator = comparator;
        return this;
    }

    public static SortedDirectoryScanner instance() {
        return new SortedDirectoryScanner();
    }

    protected File[] listEligibleFiles(File directory) {
        File[] files = super.listEligibleFiles(directory);
        if (files != null && this.comparator != null) {
            Arrays.sort(files, this.comparator);
        }
        return files;
    }

    private static class NameComparator
    implements Comparator<File> {
        private static NameComparator singleton = new NameComparator();

        private NameComparator() {
        }

        @Override
        public int compare(File f1, File f2) {
            String s1 = f1 == null ? "" : f1.getName();
            String s2 = f2 == null ? "" : f2.getName();
            return s1.compareTo(s2);
        }

        public static NameComparator singleton() {
            return singleton;
        }

        public static NameComparator instance() {
            return new NameComparator();
        }
    }
}

