/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.tempdb;

import java.io.File;
import sk.antons.tempdb.TempDbException;
import sk.antons.tempdb.base.DbFile;
import sk.antons.tempdb.sequence.SequenceDb;
import sk.antons.tempdb.sequence.SequenceDbReader;
import sk.antons.tempdb.sequence.SequenceDbWriter;
import sk.antons.tempdb.serialization.BytesDeserializer;
import sk.antons.tempdb.serialization.BytesSerializer;

public class SequenceDbBuilder<V> {
    private DbFile dbfile;
    private BytesDeserializer<V> deserializer;
    private BytesSerializer<V> serializer;

    private SequenceDbBuilder(Class<V> clazz) {
    }

    public static <E> SequenceDbBuilder<E> instance(Class<E> clazz) {
        return new SequenceDbBuilder<E>(clazz);
    }

    public SequenceDbBuilder<V> dbfile(DbFile dbfile) {
        this.dbfile = dbfile;
        return this;
    }

    public SequenceDbBuilder<V> file(File file) {
        this.dbfile = DbFile.instance(file);
        return this;
    }

    public SequenceDbBuilder<V> file(String filename) {
        this.dbfile = DbFile.instance(filename);
        return this;
    }

    public SequenceDbBuilder<V> tempfile(String prefix, String postfix, boolean deleteOnExit) {
        this.dbfile = DbFile.temporary(prefix, postfix, deleteOnExit);
        return this;
    }

    public SequenceDbBuilder<V> serializer(BytesSerializer<V> serializer) {
        this.serializer = serializer;
        return this;
    }

    public SequenceDbBuilder<V> deserializer(BytesDeserializer<V> deserializer) {
        this.deserializer = deserializer;
        return this;
    }

    public SequenceDbReader<V> sequenceDbReader() {
        if (this.dbfile == null) {
            throw new TempDbException("No dbfile defined fo new database");
        }
        if (this.deserializer == null) {
            throw new TempDbException("No deserializer defined fo new database");
        }
        return new SequenceDbReader<V>(this.dbfile, this.deserializer);
    }

    public SequenceDbWriter<V> sequenceDbWriter() {
        if (this.dbfile == null) {
            throw new TempDbException("No dbfile defined fo new database");
        }
        if (this.serializer == null) {
            throw new TempDbException("No serializer defined fo new database");
        }
        return new SequenceDbWriter<V>(this.dbfile, this.serializer);
    }

    public SequenceDb<V> sequenceDb() {
        if (this.dbfile == null) {
            throw new TempDbException("No dbfile defined fo new database");
        }
        if (this.serializer == null) {
            throw new TempDbException("No serializer defined fo new database");
        }
        if (this.deserializer == null) {
            throw new TempDbException("No deserializer defined fo new database");
        }
        return new SequenceDb<V>(this.dbfile, this.serializer, this.deserializer);
    }
}

