/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.tempdb.base;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import sk.antons.tempdb.TempDbException;

public class DbFile {
    private File file;

    public DbFile(File file) {
        this.file = file;
        this.check();
    }

    public static DbFile instance(File file) {
        return new DbFile(file);
    }

    public static DbFile instance(String filename) {
        return new DbFile(new File(filename));
    }

    public static DbFile temporary(String prefix, String postfix, boolean deleteOnExit) {
        try {
            File f = File.createTempFile(prefix, prefix);
            if (deleteOnExit) {
                f.deleteOnExit();
            }
            return new DbFile(f);
        }
        catch (Exception e) {
            throw new TempDbException("Unable to create temp database file", e);
        }
    }

    private void check() {
        if (this.file == null) {
            throw new TempDbException("Null db file");
        }
        if (this.file.exists()) {
            return;
        }
        try {
            File parent = this.file.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
        }
        catch (Exception e) {
            throw new TempDbException("Unable to create parent folder for " + this.file, e);
        }
    }

    public boolean exists() {
        return this.file.exists();
    }

    public void checkExistence() {
        if (this.file.exists()) {
            return;
        }
        throw new TempDbException("Database file not exists '" + this.file + "'");
    }

    public void delete() {
        this.file.delete();
    }

    public InputStream inputStream() {
        try {
            return new BufferedInputStream(new FileInputStream(this.file), 20000);
        }
        catch (Exception e) {
            throw new TempDbException("Unable to create input stream from '" + this.file + "'");
        }
    }

    public OutputStream outputStream() {
        try {
            return new BufferedOutputStream(new FileOutputStream(this.file), 20000);
        }
        catch (Exception e) {
            throw new TempDbException("Unable to create output stream from '" + this.file + "'");
        }
    }

    public RandomAccessFile randomAccessFile() {
        try {
            return new RandomAccessFile(this.file, "rw");
        }
        catch (Exception e) {
            throw new TempDbException("Unable to create random access file from '" + this.file + "'");
        }
    }

    public String toString() {
        return "DbFile{" + this.file + '}';
    }
}

