/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.tempdb.serialization;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import sk.antons.tempdb.serialization.BytesDeserializer;
import sk.antons.tempdb.serialization.BytesSerializer;

public class StringSerialization {
    private static final Serializer serializer = new Serializer();
    private static final Deserializer deserializer = new Deserializer();

    public static Serializer serializer() {
        return serializer;
    }

    public static Deserializer deserializer() {
        return deserializer;
    }

    public static class Deserializer
    implements BytesDeserializer<String> {
        @Override
        public String deserialize(DataInputStream dis) throws IOException {
            return dis.readUTF();
        }
    }

    public static class Serializer
    implements BytesSerializer<String> {
        @Override
        public void serialize(String value, DataOutputStream dos) throws IOException {
            if (value == null) {
                value = "";
            }
            dos.writeUTF(value);
        }
    }
}

