/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.tempdb.tree;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import sk.antons.tempdb.TempDbException;
import sk.antons.tempdb.base.AbstractDb;
import sk.antons.tempdb.base.DbByteArrayInputStream;
import sk.antons.tempdb.base.DbByteArrayOutputStream;
import sk.antons.tempdb.base.DbFile;
import sk.antons.tempdb.serialization.BytesDeserializer;
import sk.antons.tempdb.serialization.BytesSerializer;

public class AvlTreeDb<K, V>
extends AbstractDb {
    protected BytesSerializer<K> keyserializer;
    protected BytesDeserializer<K> keydeserializer;
    protected BytesSerializer<V> serializer;
    protected BytesDeserializer<V> deserializer;
    protected RandomAccessFile raf;
    protected long index = 0L;
    protected long size = 0L;
    private DbByteArrayOutputStream keyos;
    private DataOutputStream keydos;
    private DbByteArrayInputStream keyis;
    private DataInputStream keydis;
    private DbByteArrayOutputStream os;
    private DataOutputStream dos;
    private DbByteArrayInputStream is;
    private DataInputStream dis;
    long rootId = -1L;

    public AvlTreeDb(DbFile dbfile, BytesSerializer<K> keyserializer, BytesDeserializer<K> keydeserializer, BytesSerializer<V> serializer, BytesDeserializer<V> deserializer) {
        super(dbfile);
        this.keyserializer = keyserializer;
        this.keydeserializer = keydeserializer;
        this.serializer = serializer;
        this.deserializer = deserializer;
        this.raf = dbfile.randomAccessFile();
        if (dbfile.exists()) {
            try {
                this.size = this.raf.length();
            }
            catch (IOException e) {
                throw new TempDbException("Unable to read file lenagth from " + dbfile, e);
            }
        }
        this.os = new DbByteArrayOutputStream();
        try {
            this.dos = new DataOutputStream(this.os);
        }
        catch (Exception e) {
            throw new TempDbException("Unable to create temporary output stream from " + dbfile, e);
        }
        this.is = new DbByteArrayInputStream(new byte[1]);
        try {
            this.dis = new DataInputStream(this.is);
        }
        catch (Exception e) {
            throw new TempDbException("Unable to create temporary input stream from " + dbfile, e);
        }
        this.keyos = new DbByteArrayOutputStream();
        try {
            this.keydos = new DataOutputStream(this.keyos);
        }
        catch (Exception e) {
            throw new TempDbException("Unable to create temporary output stream from " + dbfile, e);
        }
        this.keyis = new DbByteArrayInputStream(new byte[1]);
        try {
            this.keydis = new DataInputStream(this.keyis);
        }
        catch (Exception e) {
            throw new TempDbException("Unable to create temporary input stream from " + dbfile, e);
        }
    }

    @Override
    public void close() {
        try {
            this.raf.close();
        }
        catch (Exception e) {
            throw new TempDbException("Unable to close random access file from " + this.dbfile, e);
        }
    }

    public synchronized void put(K key, V value) {
        try {
            long newroot;
            int sz;
            int keysz;
            boolean first = false;
            if (this.size == 0L) {
                this.raf.writeLong(8L);
                this.size = 8L;
                first = true;
            }
            Node node = new Node();
            node.id = this.size;
            node.keySize = keysz = this.serializeKey(key);
            this.os.reset();
            this.serializer.serialize(value, this.dos);
            node.valueSize = sz = this.os.count();
            this.raf.seek(this.size);
            this.raf.writeLong(node.left);
            this.raf.writeLong(node.right);
            this.raf.writeLong(node.next);
            this.raf.writeInt(node.height);
            this.raf.writeInt(node.keySize);
            this.raf.writeInt(node.valueSize);
            this.raf.write(this.keyos.buff(), 0, keysz);
            this.raf.write(this.os.buff(), 0, sz);
            this.size = this.size + 8L + 8L + 8L + 4L + 4L + 4L + (long)keysz + (long)sz;
            if (first) {
                return;
            }
            long root = this.rootId();
            if (root != (newroot = this.insert(root, node.id, this.keydata()))) {
                this.raf.seek(0L);
                this.raf.writeLong(newroot);
                this.rootId = newroot;
            }
        }
        catch (Exception e) {
            throw new TempDbException("Unable to write to random access file from " + this.dbfile, e);
        }
    }

    private long rootId() throws IOException {
        if (this.rootId > 0L) {
            return this.rootId;
        }
        if (this.size <= 0L) {
            return 0L;
        }
        this.raf.seek(0L);
        this.rootId = this.raf.readLong();
        return this.rootId;
    }

    public synchronized List<V> get(K key) {
        ArrayList<V> list = new ArrayList<V>();
        if (this.size == 0L) {
            return list;
        }
        try {
            int keysz = this.serializeKey(key);
            byte[] keydata = new byte[keysz];
            System.arraycopy(this.keyos.buff(), 0, keydata, 0, keysz);
            long root = this.rootId();
            Node node = this.findNode(root, keydata);
            if (node != null) {
                node = this.loadNode(node.id, true, true);
            }
            while (node != null) {
                list.add(this.bufferedValue());
                node = this.loadNode(node.next, true, true);
            }
            return list;
        }
        catch (Exception e) {
            throw new TempDbException("Unable to read random access file from " + this.dbfile, e);
        }
    }

    private int serializeKey(K key) throws IOException {
        this.keyos.reset();
        this.keyserializer.serialize(key, this.keydos);
        return this.keyos.count();
    }

    private byte[] keydata() throws IOException {
        byte[] rv = new byte[this.keyos.count()];
        System.arraycopy(this.keyos.buff(), 0, rv, 0, this.keyos.count());
        return rv;
    }

    private Node findNode(long id, byte[] keydata) throws IOException {
        Node node = this.loadNode(id, true, false);
        if (node == null) {
            return null;
        }
        int compare = AvlTreeDb.compareKeyData(this.keyis.buff(), this.keyis.count(), keydata, keydata.length);
        if (compare == 0) {
            return node;
        }
        if (compare > 0) {
            return this.findNode(node.right, keydata);
        }
        return this.findNode(node.left, keydata);
    }

    private static int compareKeyData(byte[] data1, int length1, byte[] data2, int length2) {
        if (data1 == null && data2 == null) {
            return 0;
        }
        if (data1 == null) {
            return -1;
        }
        if (data2 == null) {
            return 1;
        }
        int size = length1;
        if (length2 < size) {
            size = length2;
        }
        for (int i = 0; i < size; ++i) {
            if (data1[i] < data2[i]) {
                return -1;
            }
            if (data1[i] <= data2[i]) continue;
            return 1;
        }
        if (length1 < length2) {
            return -1;
        }
        if (length1 > length2) {
            return 1;
        }
        return 0;
    }

    private Node loadNode(long id, boolean loadKey, boolean loadValue) throws IOException {
        int n;
        if (id <= 0L) {
            return null;
        }
        this.raf.seek(id);
        Node node = new Node();
        node.id = id;
        node.left = this.raf.readLong();
        node.right = this.raf.readLong();
        node.next = this.raf.readLong();
        node.height = this.raf.readInt();
        node.keySize = this.raf.readInt();
        node.valueSize = this.raf.readInt();
        if (loadKey || loadValue) {
            this.keyis.allocate(node.keySize);
            n = this.raf.read(this.keyis.buff(), 0, node.keySize);
            this.keyis.count(n);
        }
        if (loadValue) {
            this.is.allocate(node.valueSize);
            n = this.raf.read(this.is.buff(), 0, node.valueSize);
            this.is.count(n);
        }
        return node;
    }

    private V bufferedValue() throws IOException {
        V rv = this.deserializer.deserialize(this.dis);
        return rv;
    }

    private K bufferedKey() throws IOException {
        K rv = this.keydeserializer.deserialize(this.keydis);
        return rv;
    }

    private void saveNode(Node node) throws IOException {
        if (node == null) {
            return;
        }
        if (node.id <= 0L) {
            return;
        }
        this.raf.seek(node.id);
        this.raf.writeLong(node.left);
        this.raf.writeLong(node.right);
        this.raf.writeLong(node.next);
        this.raf.writeInt(node.height);
    }

    private long insert(long id, long newId, byte[] keydata) throws IOException {
        if (id <= 0L) {
            return newId;
        }
        Node node = this.loadNode(id, true, false);
        if (node == null) {
            throw new IllegalStateException("Unknown address " + id);
        }
        int compare = AvlTreeDb.compareKeyData(this.keyis.buff(), this.keyis.count(), keydata, keydata.length);
        if (compare == 0) {
            while (node.next > 0L) {
                node = this.loadNode(node.next, false, false);
            }
            node.next = newId;
            this.saveNode(node);
            return id;
        }
        if (compare > 0) {
            node.right = this.insert(node.right, newId, keydata);
        } else {
            node.left = this.insert(node.left, newId, keydata);
        }
        this.saveNode(node);
        Node n = this.rebalance(node);
        return n.id;
    }

    private Node rebalance(Node node) throws IOException {
        this.updateHeight(node);
        int balance = this.getBalance(node);
        if (balance > 1) {
            Node right = this.loadNode(node.right, false, false);
            Node rightright = this.loadNode(right.right, false, false);
            Node rightleft = this.loadNode(right.left, false, false);
            if (this.height(rightright) > this.height(rightleft)) {
                node = this.rotateLeft(node);
            } else {
                node.right = this.rotateRight((Node)right).id;
                this.saveNode(node);
                node = this.rotateLeft(node);
            }
        } else if (balance < -1) {
            Node left = this.loadNode(node.left, false, false);
            Node leftright = this.loadNode(left.right, false, false);
            Node leftleft = this.loadNode(left.left, false, false);
            if (this.height(leftleft) > this.height(leftright)) {
                node = this.rotateRight(node);
            } else {
                node.left = this.rotateLeft((Node)left).id;
                this.saveNode(node);
                node = this.rotateRight(node);
            }
        }
        return node;
    }

    private Node rotateLeft(Node node) throws IOException {
        Node right = this.loadNode(node.right, false, false);
        Node righleft = this.loadNode(right.left, false, false);
        right.left = node == null ? 0L : node.id;
        node.right = righleft == null ? 0L : righleft.id;
        this.updateHeight(node);
        this.updateHeight(right);
        this.saveNode(right);
        this.saveNode(node);
        return right;
    }

    private Node rotateRight(Node node) throws IOException {
        Node left = this.loadNode(node.left, false, false);
        Node leftright = this.loadNode(left.right, false, false);
        left.right = node == null ? 0L : node.id;
        node.left = leftright == null ? 0L : leftright.id;
        this.updateHeight(node);
        this.updateHeight(left);
        this.saveNode(left);
        this.saveNode(node);
        return left;
    }

    private void updateHeight(Node node) throws IOException {
        if (node == null) {
            return;
        }
        int oldval = node.height;
        Node right = this.loadNode(node.right, false, false);
        Node left = this.loadNode(node.left, false, false);
        node.height = Math.max(this.height(right), this.height(left)) + 1;
        if (node.height != oldval) {
            this.saveNode(node);
        }
    }

    private int height(Node node) {
        if (node == null) {
            return 0;
        }
        return node.height;
    }

    private int getBalance(Node node) throws IOException {
        if (node == null) {
            return 0;
        }
        Node right = this.loadNode(node.right, false, false);
        Node left = this.loadNode(node.left, false, false);
        return this.height(right) - this.height(left);
    }

    public String dump() {
        try {
            if (this.size <= 0L) {
                return "EMPTY";
            }
            StringBuilder sb = new StringBuilder();
            long root = this.rootId();
            if (root <= 0L) {
                return "EMPTY";
            }
            this.dump(root, "", sb);
            return sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.toString();
        }
    }

    public void dump(long id, String prefix, StringBuilder sb) throws IOException {
        if (id <= 0L) {
            return;
        }
        Node node = this.loadNode(id, true, false);
        if (node == null) {
            return;
        }
        K key = this.bufferedKey();
        sb.append(prefix).append(key);
        sb.append(" id: ").append(node.id);
        sb.append(" left: ").append(node.left);
        sb.append(" right: ").append(node.left);
        sb.append(" next: ").append(node.next);
        sb.append(" height: ").append(node.height);
        sb.append("\n");
        this.dump(node.left, prefix + "|  ", sb);
        this.dump(node.right, prefix + "|  ", sb);
    }

    private static class Node {
        protected long id;
        protected long left;
        protected long right;
        protected long next;
        protected int height;
        protected int keySize;
        protected int valueSize;

        private Node() {
        }

        public String toString() {
            return "Node{id=" + this.id + ", left=" + this.left + ", right=" + this.right + ", next=" + this.next + ", height=" + this.height + ", keySize=" + this.keySize + ", valueSize=" + this.valueSize + '}';
        }
    }
}

