/*
 * Decompiled with CFR 0.152.
 */
package io.github.archipelagomw.parts;

import com.google.gson.annotations.SerializedName;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Game
implements Serializable {
    @SerializedName(value="checksum")
    public String checksum;
    @SerializedName(value="item_name_to_id")
    public Map<String, Long> itemNameToId = new HashMap<String, Long>();
    @SerializedName(value="location_name_to_id")
    public Map<String, Long> locationNameToId = new HashMap<String, Long>();
    private final Map<Long, String> idToItem = new ConcurrentHashMap<Long, String>();
    private final Map<Long, String> idToLocation = new ConcurrentHashMap<Long, String>();

    public String getItem(long itemID) {
        if (this.idToItem.isEmpty()) {
            for (Map.Entry<String, Long> entry : this.itemNameToId.entrySet()) {
                this.idToItem.put(entry.getValue(), entry.getKey());
            }
        }
        if (!this.idToItem.containsKey(itemID)) {
            return String.format("Unknown Item [%d]", itemID);
        }
        return this.idToItem.get(itemID);
    }

    public String getLocation(long locationID) {
        if (this.idToLocation.isEmpty()) {
            for (Map.Entry<String, Long> entry : this.locationNameToId.entrySet()) {
                this.idToLocation.put(entry.getValue(), entry.getKey());
            }
        }
        if (!this.idToLocation.containsKey(locationID)) {
            return String.format("Unknown Location [%d]", locationID);
        }
        return this.idToLocation.get(locationID);
    }
}

