package com.sentray.kmmprotocolmodule.cryptor.common.hash.sha

import com.sentray.kmmprotocolmodule.cryptor.common.hash.Hash
import com.sentray.kmmprotocolmodule.cryptor.common.hash.MultipartHash

/**
 * Created by Ugljesa Jovanovic
 * ugljesa.jovanovic@ionspin.com
 * on 24-May-2020
 */
internal object Sha256Properties {
    const val MAX_HASH_BYTES = 32
}


 internal interface Sha256 : MultipartHash {
    override val MAX_HASH_BYTES: Int
        get() = Sha256Properties.MAX_HASH_BYTES
}


@kotlin.ExperimentalUnsignedTypes
 internal interface StatelessSha256 : Hash {
    override val MAX_HASH_BYTES: Int
        get() = Sha256Properties.MAX_HASH_BYTES

    fun digest(
        inputMessage: UByteArray = ubyteArrayOf()
    ): UByteArray
}
