package com.sentray.kmmprotocolmodule.network.dataClasses

import com.sentray.kmmprotocolmodule.utilityToolKit.genericClasses.MutableStack
import com.sentray.kmmprotocolmodule.utilityToolKit.genericClasses.mutableStackOf
import kotlinx.coroutines.sync.Mutex
import kotlinx.coroutines.sync.withLock

internal class TransmitMessageCache {
    private val cacheMutex = Mutex(locked = false)
    private val messageCacheStack: MutableStack<String> = mutableStackOf()

    suspend fun insertData(message: String) {
        cacheMutex.withLock {
            messageCacheStack.push(message)
        }
    }

    suspend fun popData(): String? {
        cacheMutex.withLock {
            if (messageCacheStack.isNotEmpty()) {
                return messageCacheStack.pop()
            } else {
                return null
            }
        }
    }
}