package com.sentray.kmmprotocolmodule.utilityToolKit.asyncKit

import kotlinx.coroutines.*
import kotlin.time.Duration

internal class KAsync {
    companion object {
        fun main(block: () -> Unit): Job {
            return CoroutineScope(Dispatchers.Main).launch {
                block.invoke()
            }
        }

        fun mainAsync(block: () -> Unit): Deferred<Unit> {
            return CoroutineScope(Dispatchers.Main).async {
                block.invoke()
            }
        }

        fun mainDelay(block: () -> Unit, duration: Duration): Job {
            return CoroutineScope(Dispatchers.Default).launch {
                delay(duration)
                CoroutineScope(Dispatchers.Main).launch {
                    block.invoke()
                }
            }
        }

        fun background(block: suspend () -> Unit): Job {
            return CoroutineScope(Dispatchers.Default).launch {
                block.invoke()
            }
        }

        fun backgroundAsync(block: suspend () -> Unit): Deferred<Unit> {
            return CoroutineScope(Dispatchers.Default).async {
                block.invoke()
            }
        }

        fun backgroundDelay(block: suspend () -> Unit, duration: Duration): Job {
            return CoroutineScope(Dispatchers.Default).launch {
                delay(duration)
                block.invoke()
            }
        }
    }
}