package com.sentray.kmmprotocolmodule.network.smartlink

import cocoapods.WiLinkIOSSmartLink.SmartLinkSDK
import com.sentray.kmmprotocolmodule.utilityToolKit.asyncKit.KAsync
import com.sentray.kmmprotocolmodule.utilityToolKit.loggerKit.KMMLogger
import kotlinx.cinterop.ExperimentalForeignApi

internal actual class SmartLinkManager {
    actual companion object {
        actual fun startSmartLink(
            ssid: String,
            pwd: String,
            timeoutSeconds: Long,
            successCallback: SuccessCallback,
            failureCallback: FailureCallback,
            finishCallback: FinishCallback
        ) {
            startSmartLinkForIOS(
                ssid,
                pwd,
                timeoutSeconds,
                successCallback,
                failureCallback,
                finishCallback
            )
        }

        @OptIn(ExperimentalForeignApi::class)
        private fun startSmartLinkForIOS(
            ssid: String,
            pwd: String,
            timeoutSeconds: Long,
            successCallback: SuccessCallback,
            failureCallback: FailureCallback,
            finishCallback: FinishCallback
        ) {
            SmartLinkSDK().startSmartlink(
                ssid,
                pwd,
                true,
                timeoutSeconds,
                processBlock = { progress ->
                    KMMLogger.d("SmartLink Progressing : $progress")
                },
                successBlock = { deviceFound ->
                    deviceFound?.let {
                        KMMLogger.d("SmartLink succeed: ${it.ip} : ${it.mac}")
                        KAsync.main {
                            successCallback.invoke(it.mac, it.ip)
                        }
                    }

                },
                failBlock = { msg ->
                    msg?.let {
                        KMMLogger.d("SmartLink failure : $it")
                        KAsync.main {
                            failureCallback.invoke(it)
                        }
                    }
                },
                endBlock = {
                    KMMLogger.d("SmartLink End")
                    KAsync.main {
                        finishCallback.invoke()
                    }
                })
        }
    }
}