package com.sentray.kmmprotocolmodule.network.udp

import com.sentray.kmmprotocolmodule.utilityToolKit.asyncKit.KAsync
import com.sentray.kmmprotocolmodule.utilityToolKit.genericClasses.KmmTimer
import com.sentray.kmmprotocolmodule.utilityToolKit.loggerKit.KMMLogger
import kotlin.time.Duration.Companion.milliseconds
import kotlin.time.Duration.Companion.seconds

typealias DeviceFoundCallback = (mac: String, ip: String, name: String?) -> Unit
typealias DiscoveryFinishedCallback = (amount: Int) -> Unit

//TODO : MAC电脑执行 iOS 单元测试时，需先关闭防火墙，否则无法找到中控
internal object UdpClientManager {
    private const val host = "255.255.255.255"
    private const val port = 48899
    private const val discoveryMessage = "HF-A11ASSISTHREAD"
    private const val discoveryCount = 5

    private val platformUdpClient = PlatformUdpClient()
    private val timer = KmmTimer()
    private val deviceFoundMap: MutableMap<String, String> = mutableMapOf()

    fun startLanDiscover(
        deviceFoundCallback: DeviceFoundCallback,
        discoveryFinishedCallback: DiscoveryFinishedCallback
    ) {
        var discoveryCounter = 0
        deviceFoundMap.clear()

        platformUdpClient.setReceiveCallback {
            val contentList = it.split(",")
            if (contentList.count() < 2) return@setReceiveCallback

            val ip = contentList[0]
            val mac = contentList[1]
            var name: String? = null
            if (contentList.count() == 3) {
                name = contentList[2]
            }
            deviceFoundMap[mac] ?: run {
                deviceFoundMap[mac] = ip
                KAsync.main {
                    deviceFoundCallback.invoke(mac, ip, name)
                }
            }
        }

        timer.startScheduleTimer(500.milliseconds) {
            if (discoveryCounter >= discoveryCount) {
                timer.stopScheduleTimer()
                platformUdpClient.disconnect()
                KAsync.main {
                    discoveryFinishedCallback(deviceFoundMap.size)
                    deviceFoundMap.clear()
                }
            } else {
                val result = platformUdpClient.broadcastPackage(host, port, discoveryMessage)
                if (result) {
                    KMMLogger.d("UDP 广播成功 : $discoveryCounter")
                }
                discoveryCounter++
            }
        }
    }
}
