package com.sentray.kmmprotocolmodule.tcpProtocol.definition.deviceType

import kotlin.jvm.JvmStatic


internal class DeviceTypeUtil {
    companion object {
        private val deviceTypeMap: HashMap<String, Int> = hashMapOf()
        init {
            deviceTypeMap[DeviceTypeSet.MomSon.raw] = 1
            deviceTypeMap[DeviceTypeSet.SonAlarm.raw] = 2
            deviceTypeMap[DeviceTypeSet.Son86_1S.raw] = 3
            deviceTypeMap[DeviceTypeSet.SonSW_1D.raw] = 4
            deviceTypeMap[DeviceTypeSet.SonSW_1S.raw] = 5
            deviceTypeMap[DeviceTypeSet.SonSW_2D.raw] = 6
            deviceTypeMap[DeviceTypeSet.SonSW_2S.raw] = 7
            deviceTypeMap[DeviceTypeSet.SonSW_3D.raw] = 8
            deviceTypeMap[DeviceTypeSet.SonSW_3S.raw] = 9
            deviceTypeMap[DeviceTypeSet.Son86_1S_315_2262_SC.raw] = 10
            deviceTypeMap[DeviceTypeSet.SonSW_1S_433_2262.raw] = 11
            deviceTypeMap[DeviceTypeSet.SonLight_1S_433_1527_SC.raw] = 12
            deviceTypeMap[DeviceTypeSet.SonPlug_1S_433_1527.raw] = 13
            deviceTypeMap[DeviceTypeSet.SonLED_1S.raw] = 14
            deviceTypeMap[DeviceTypeSet.SonDimmer_1D.raw] = 15
            deviceTypeMap[DeviceTypeSet.SonDimmer_2D.raw] = 16
            deviceTypeMap[DeviceTypeSet.SonDimmer_3D.raw] = 17
            deviceTypeMap[DeviceTypeSet.SonDimmerSW_1D.raw] = 18
            deviceTypeMap[DeviceTypeSet.SonDimmerSW_2D.raw] = 19
            deviceTypeMap[DeviceTypeSet.SonDimmerSW_3D.raw] = 20
            deviceTypeMap[DeviceTypeSet.SonTouchSW_1D.raw] = 21
            deviceTypeMap[DeviceTypeSet.SonTouchSW_2D.raw] = 22
            deviceTypeMap[DeviceTypeSet.SonTouchSW_3D.raw] = 23
            deviceTypeMap[DeviceTypeSet.SonBoxSW_1D.raw] = 24
            deviceTypeMap[DeviceTypeSet.SonBoxSW_2D.raw] = 25
            deviceTypeMap[DeviceTypeSet.SonBoxSW_3D.raw] = 26
            deviceTypeMap[DeviceTypeSet.SonDimmerPWM_1D.raw] = 27
            deviceTypeMap[DeviceTypeSet.SonDimmerPWM_2D.raw] = 28
            deviceTypeMap[DeviceTypeSet.SonDimmerPWM_3D.raw] = 29
            deviceTypeMap[DeviceTypeSet.SonPlug_1D.raw] = 30
            deviceTypeMap[DeviceTypeSet.SonPlug_2D.raw] = 31
            deviceTypeMap[DeviceTypeSet.SonPlug_3D.raw] = 32
            deviceTypeMap[DeviceTypeSet.SonPlug_1Dx2.raw] = 33
            deviceTypeMap[DeviceTypeSet.SonPlug_2Dx2.raw] = 34
            deviceTypeMap[DeviceTypeSet.SonPlug_3Dx2.raw] = 35
            deviceTypeMap[DeviceTypeSet.SonCurtain_1D.raw] = 36
            deviceTypeMap[DeviceTypeSet.SonCurtain_2D.raw] = 37
            deviceTypeMap[DeviceTypeSet.SonTempLED.raw] = 39
            deviceTypeMap[DeviceTypeSet.SonRGBLED.raw] = 42
            deviceTypeMap[DeviceTypeSet.SonRGBWLED.raw] = 43
            deviceTypeMap[DeviceTypeSet.SonOutlet_1D.raw] = 45
            deviceTypeMap[DeviceTypeSet.SonIR.raw] = 48
            deviceTypeMap[DeviceTypeSet.SonLock.raw] = 51
            deviceTypeMap[DeviceTypeSet.SonCamera.raw] = 52
            deviceTypeMap[DeviceTypeSet.SonCurtainLoc.raw] = 53
            deviceTypeMap[DeviceTypeSet.SonDimmer_4D_E_LMS.raw] = 55
            deviceTypeMap[DeviceTypeSet.SonOutlet_1D_E.raw] = 56
            deviceTypeMap[DeviceTypeSet.SonDimmer_2D_1.raw] = 61
            deviceTypeMap[DeviceTypeSet.SonDimmer_3D_1.raw] = 62
            deviceTypeMap[DeviceTypeSet.SonDimmer_3D_2.raw] = 63
            deviceTypeMap[DeviceTypeSet.SonDimmerSW_2D_1.raw] = 64
            deviceTypeMap[DeviceTypeSet.SonDimmerSW_3D_1.raw] = 65
            deviceTypeMap[DeviceTypeSet.SonDimmerSW_3D_2.raw] = 66
            deviceTypeMap[DeviceTypeSet.SonTouchSW_2D_1.raw] = 67
            deviceTypeMap[DeviceTypeSet.SonTouchSW_3D_1.raw] = 68
            deviceTypeMap[DeviceTypeSet.SonTouchSW_3D_2.raw] = 69
            deviceTypeMap[DeviceTypeSet.SonBoxSW_2D_1.raw] = 70
            deviceTypeMap[DeviceTypeSet.SonBoxSW_3D_1.raw] = 71
            deviceTypeMap[DeviceTypeSet.SonBoxSW_3D_2.raw] = 72
            deviceTypeMap[DeviceTypeSet.RemoteController.raw] = 201
            deviceTypeMap[DeviceTypeSet.SecurityController.raw] = 202
            deviceTypeMap[DeviceTypeSet.EntranceGuard.raw] = 203
            deviceTypeMap[DeviceTypeSet.InfraredWarning.raw] = 204
            deviceTypeMap[DeviceTypeSet.FuelGasWarning.raw] = 205
            deviceTypeMap[DeviceTypeSet.ScenePanel_2D.raw] = 206
            deviceTypeMap[DeviceTypeSet.ScenePanel_6D.raw] = 207
            deviceTypeMap[DeviceTypeSet.ScenePanel_3D.raw] = 208
            deviceTypeMap[DeviceTypeSet.Scenepanel_1D.raw] = 209
            deviceTypeMap[DeviceTypeSet.EnvMonitor_W.raw] = 311
            deviceTypeMap[DeviceTypeSet.EnvMonitorPlus_W.raw] = 312
        }

        @JvmStatic
        fun findDeviceTypeNumber(deviceTypeString: String): Int? {
            return deviceTypeMap[deviceTypeString]
        }

        @JvmStatic
        fun findDeviceTypeString(deviceTypeNumber: Int): String? {
            val foundKeys = deviceTypeMap.filterValues {
                it == deviceTypeNumber
            }

            return when (foundKeys.isEmpty()) {
                true -> null
                false -> foundKeys.keys.first()
            }
        }
    }
}