package com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.paraContent

import com.sentray.kmmprotocolmodule.utilityToolKit.HexToolKit
import kotlinx.serialization.Serializable

@Serializable
internal class TimerParaV2 {
    var timerBasePara: TimerParaV1.TimerBasePara = TimerParaV1.TimerBasePara()
    var userActionMask: List<Boolean> = listOf()    //由 actionMask0 与 actionMask1 组成的 64bit mask
    var triggerStatus: List<Boolean> = listOf()
    var triggerMask: List<Boolean> = listOf()

    //[index,enabled,posix,weekMask,actionMask0,actionMask1,triggerStatus,triggerMask]
    
    fun initialFromRawList(timerParaV2List: List<Long>) {
        if (timerParaV2List.count() == 8) {
            this.timerBasePara.timerIndex = timerParaV2List[0].toInt()
            this.timerBasePara.enable = timerParaV2List[1] > 0
            this.timerBasePara.posix = timerParaV2List[2]
            val weekMaskNumber = timerParaV2List[3].toULong()
            this.timerBasePara.setWeekMaskUTC0FromProtocol(HexToolKit.longToBoolList(weekMaskNumber,
                7))
            val actionMask0BoolList =
                HexToolKit.longToBoolList(timerParaV2List[4].toULong(), 32)
            val actionMask1BoolList = HexToolKit.longToBoolList(timerParaV2List[5].toULong(), 32)
            val actionMaskBoolList = mutableListOf<Boolean>()
            actionMaskBoolList.addAll(0, actionMask0BoolList)
            actionMaskBoolList.addAll(32, actionMask1BoolList)
            this.userActionMask = actionMaskBoolList.toList()
            this.triggerStatus = HexToolKit.longToBoolList(timerParaV2List[6].toULong())
            this.triggerMask = HexToolKit.longToBoolList(timerParaV2List[7].toULong())
        }
    }

    
    fun toParaList(): List<Long> {
        val paraList = mutableListOf<Long>()
        paraList.add(0, timerBasePara.timerIndex.toLong())
        paraList.add(1, when (timerBasePara.enable) {
            true -> 1
            false -> 0
        })
        paraList.add(2, timerBasePara.posix)
        paraList.add(3, timerBasePara.getWeekMaskForUTC0().toULong().toLong())

        val actionMask0List: List<Boolean>
        val actionMask1List: List<Boolean>

        if (userActionMask.count() > 32) {
            actionMask0List = userActionMask.subList(0, 32)
            actionMask1List = userActionMask.subList(32, userActionMask.count())
        } else {
            actionMask0List = userActionMask.subList(0, userActionMask.count())
            actionMask1List = listOf(false)
        }

        val actionMask0Number = HexToolKit.boolListToLong(actionMask0List)
        val actionMask1Number = HexToolKit.boolListToLong(actionMask1List)

        paraList.add(4, actionMask0Number.toLong())
        paraList.add(5, actionMask1Number.toLong())

        val triggerStatusNumber = HexToolKit.boolListToLong(triggerStatus)
        val triggerMaskNumber = HexToolKit.boolListToLong(triggerMask)

        paraList.add(6, triggerStatusNumber.toLong())
        paraList.add(7, triggerMaskNumber.toLong())

        return paraList
    }
}