package com.sentray.kmmprotocolmodule.utilityToolKit.loggerKit

import kotlinx.datetime.Clock
import kotlinx.datetime.LocalDateTime
import kotlinx.datetime.TimeZone
import kotlinx.datetime.toLocalDateTime
import kotlin.jvm.JvmStatic

private fun LocalDateTime.toPrintString(): String {
//    return "${this.date} ${this.hour}:${this.minute}:${this.second}.${(this.nanosecond / 1000)}"
    return this.toString()
}

internal class KMMLogger {
    companion object {
        @JvmStatic
        fun d(message: String?) {
            val timerDate = Clock.System.now().toLocalDateTime(TimeZone.currentSystemDefault())
            println("\u001B${timerDate.toPrintString()} KMMLogger [Debug] $message")
        }

        @JvmStatic
        fun e(message: String?) {
            val timerDate = Clock.System.now().toLocalDateTime(TimeZone.currentSystemDefault())
            println("\u001B${timerDate.toPrintString()} KMMLogger [Error] $message")
        }
    }
}