package com.sentray.kmmprotocolmodule.cryptor.enumDefinition

import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.enumDefinition.Cmd

internal enum class CmdType(val raw: Int) {
    ControllerToServer(1),
    ControllerToApp(2),
    AppToController(3),
    AppToServer(4),
    ServerToController(5),
    ServerToApp(6),
    Login(7);

    companion object {
        fun getCmdType(cmd: Cmd): CmdType {
            return when (cmd) {
                Cmd.Login -> Login
                else -> AppToController
            }
        }
    }
}